/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.server.grizzly;

import java.io.InputStream;
import java.net.InetSocketAddress;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.utils.BufferInputStream;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.http.api.domain.entity.EmptyHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.InputStreamHttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.service.http.impl.service.domain.entity.multipart.StreamedMultipartHttpEntity;
import org.mule.service.http.impl.service.server.grizzly.BlockingTransferInputStream;
import org.mule.service.http.impl.service.server.grizzly.GrizzlyHttpMessage;

public class GrizzlyHttpRequestAdapter
extends GrizzlyHttpMessage
implements HttpRequest {
    private static final String PROTOCOL = "http";
    private static final String RESPONSE_ALREADY_SENT = "Response already sent";
    private final InputStream requestContent;
    private HttpEntity body;

    public GrizzlyHttpRequestAdapter(FilterChainContext filterChainContext, HttpContent httpContent, InetSocketAddress localAddress) {
        this(filterChainContext, httpContent, (HttpRequestPacket)httpContent.getHttpHeader(), localAddress);
    }

    public GrizzlyHttpRequestAdapter(FilterChainContext filterChainContext, HttpContent httpContent, HttpRequestPacket requestPacket, InetSocketAddress localAddress) {
        super(requestPacket, null, localAddress);
        this.requestContent = httpContent.isLast() ? new BufferInputStream(httpContent.getContent()) : new BlockingTransferInputStream((HttpHeader)requestPacket, filterChainContext);
    }

    @Override
    protected String getBaseProtocol() {
        return PROTOCOL;
    }

    public HttpEntity getEntity() {
        if (this.body == null) {
            String contentTypeValue = this.getHeaderValue("Content-Type");
            this.body = contentTypeValue != null && contentTypeValue.contains(MediaType.MULTIPART_MIXED.getPrimaryType()) ? (this.contentLength >= 0L ? new StreamedMultipartHttpEntity(this.requestContent, contentTypeValue, this.contentLength) : new StreamedMultipartHttpEntity(this.requestContent, contentTypeValue)) : (this.contentLength > 0L ? new InputStreamHttpEntity(this.requestContent, this.contentLength) : (this.contentLength == 0L ? new EmptyHttpEntity() : new InputStreamHttpEntity(this.requestContent)));
        }
        return this.body;
    }

    public void responseSent() {
        if (this.requestContent instanceof BlockingTransferInputStream) {
            ((BlockingTransferInputStream)this.requestContent).preventFurtherBlockingReading(RESPONSE_ALREADY_SENT);
        }
    }
}

