/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.functional.client;

import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.service.http.impl.functional.client.AbstractHttpClientTestCase;

public class HttpClientNoBodyTestCase
extends AbstractHttpClientTestCase {
    private HttpClient client;

    public HttpClientNoBodyTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    @Override
    protected HttpResponse setUpHttpResponse(HttpRequest request) {
        HttpResponseBuilder response = HttpResponse.builder();
        if (request.getPath().endsWith("noContent")) {
            response.statusCode(Integer.valueOf(HttpConstants.HttpStatus.NO_CONTENT.getStatusCode()));
        } else if (request.getPath().endsWith("resetContent")) {
            response.statusCode(Integer.valueOf(HttpConstants.HttpStatus.RESET_CONTENT.getStatusCode()));
        } else if (request.getPath().endsWith("notModified")) {
            response.statusCode(Integer.valueOf(HttpConstants.HttpStatus.NOT_MODIFIED.getStatusCode()));
        }
        return response.build();
    }

    @Before
    public void createClient() {
        this.client = this.service.getClientFactory().create(new HttpClientConfiguration.Builder().setName("no-body-test").build());
        this.client.start();
    }

    @After
    public void stopClient() {
        if (this.client != null) {
            this.client.stop();
        }
    }

    @Test
    public void noContentReturnsEmptyBody() throws Exception {
        this.assertEmptyOnStatus("/noContent", HttpConstants.HttpStatus.NO_CONTENT);
    }

    @Test
    public void resetContentReturnsEmptyBody() throws Exception {
        this.assertEmptyOnStatus("/resetContent", HttpConstants.HttpStatus.RESET_CONTENT);
    }

    @Test
    public void notModifiedReturnsEmptyBody() throws Exception {
        this.assertEmptyOnStatus("/notModified", HttpConstants.HttpStatus.NOT_MODIFIED);
    }

    private void assertEmptyOnStatus(String path, HttpConstants.HttpStatus expectedStatus) throws IOException, TimeoutException {
        HttpResponse response = this.client.send(HttpRequest.builder().uri(this.getUri() + path).build());
        Assert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)expectedStatus.getStatusCode()));
        Assert.assertThat((Object)response.getEntity().getBytesLength().isPresent(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)response.getEntity().getBytesLength().getAsLong(), (Matcher)Matchers.is((Object)0L));
    }
}

