/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.functional.server;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.runtime.http.api.server.HttpServerConfiguration;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.service.http.impl.functional.AbstractHttpServiceTestCase;
import org.mule.service.http.impl.functional.ResponseReceivedProbe;
import org.mule.service.http.impl.functional.server.AbstractHttpServerTestCase;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.tck.probe.JUnitLambdaProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;

public class HttpServerDelayedResponseTestCase
extends AbstractHttpServerTestCase {
    private static final String INITIAL_CHUNK = ":";
    private static final int CONNECTION_TIMEOUT_MILLIS = 500;
    private static final int PROBE_TIMEOUT_MILLIS1 = 2000;
    private static final int POLL_DELAY_MILLIS = 200;
    @ClassRule
    public static TemporaryFolder confDir = new TemporaryFolder();
    @Rule
    public SystemProperty muleHome = new SystemProperty("mule.home", HttpServerDelayedResponseTestCase.getMuleHome());
    private PollingProber pollingProber = new PollingProber(2000L, 200L);
    private Writer writer;
    private HttpClient client;

    public HttpServerDelayedResponseTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    @BeforeClass
    public static void createHttpPropertiesFile() throws Exception {
        PrintWriter writer = new PrintWriter(HttpServerDelayedResponseTestCase.getHttpPropertiesFile(), "UTF-8");
        writer.println("org.mule.runtime.http.server.socket.serverTimeout=500");
        writer.close();
    }

    @AfterClass
    public static void removeHttpPropertiesFile() {
        if (!HttpServerDelayedResponseTestCase.getHttpPropertiesFile().delete()) {
            throw new IllegalStateException("Couldn't delete properties file");
        }
    }

    private static File getHttpPropertiesFile() {
        String path = HttpServerDelayedResponseTestCase.getMuleHome();
        File conf = new File(path, "conf");
        if (!conf.exists() && !conf.mkdir()) {
            throw new IllegalStateException("Couldn't create 'conf' directory");
        }
        return new File(conf.getPath(), "http-server-sockets.conf");
    }

    private static String getMuleHome() {
        return confDir.getRoot().getAbsolutePath();
    }

    @Before
    public void setUp() throws Exception {
        this.setUpServer();
        this.server.addRequestHandler("/test", (request, callback) -> {
            this.writer = callback.startResponse(((HttpResponseBuilder)HttpResponse.builder().entity((HttpEntity)new ByteArrayHttpEntity("ignored".getBytes()))).build(), (ResponseStatusCallback)new AbstractHttpServiceTestCase.IgnoreResponseStatusCallback(), StandardCharsets.UTF_8);
            try {
                this.sendBodyPart(INITIAL_CHUNK);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
        this.client = this.service.getClientFactory().create(new HttpClientConfiguration.Builder().setName("delayed-response-test-client").setStreaming(true).build());
        this.client.start();
    }

    @Override
    protected HttpServerConfiguration.Builder configureServer(HttpServerConfiguration.Builder builder) {
        return builder.setConnectionIdleTimeout(500);
    }

    @Override
    protected String getServerName() {
        return "delayed-response-test";
    }

    @After
    public void stopClient() {
        if (this.client != null) {
            this.client.stop();
        }
    }

    @Test
    public void connectionRemainsOpenUntilWriterCloses() throws Exception {
        Reference responseReference = new Reference();
        this.client.sendAsync(this.getRequest()).whenComplete((response, exception) -> responseReference.set(response));
        this.pollingProber.check((Probe)new ResponseReceivedProbe((Reference<HttpResponse>)responseReference));
        HttpResponse response2 = (HttpResponse)responseReference.get();
        Assert.assertThat((Object)response2.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
        BufferedReader reader = new BufferedReader(new InputStreamReader(response2.getEntity().getContent()));
        this.assertBodyPart(INITIAL_CHUNK, reader);
        String firstChunk = "first chunk of real data";
        this.sendBodyPart(firstChunk);
        this.assertBodyPart(firstChunk, reader);
        Thread.sleep(1500L);
        String secondChunk = "second chunk of real data";
        this.sendBodyPart(secondChunk);
        this.assertBodyPart(secondChunk, reader);
        this.writer.close();
        this.pollingProber.check((Probe)new JUnitLambdaProbe(() -> reader.readLine() == null));
    }

    private HttpRequest getRequest() {
        return HttpRequest.builder().uri("http://localhost:" + this.port.getValue() + "/test").build();
    }

    private void sendBodyPart(String part) throws IOException {
        this.writer.write(part);
        this.writer.write("\n");
        this.writer.flush();
    }

    private void assertBodyPart(String expected, BufferedReader reader) throws IOException {
        Assert.assertThat((Object)reader.readLine(), (Matcher)Matchers.is((Object)expected));
    }
}

