/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.service.http.impl.functional;

import static org.mule.runtime.core.api.config.MuleProperties.APP_NAME_PROPERTY;
import static org.mule.runtime.core.api.config.MuleProperties.DOMAIN_NAME_PROPERTY;

import static java.lang.Long.valueOf;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.is;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;

import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.http.api.server.HttpServerFactory;
import org.mule.service.http.impl.service.HttpServiceImplementation;
import org.mule.service.http.impl.service.server.ContextHttpServerFactoryAdapter;
import org.mule.service.http.test.common.server.ServerFactoryIsolationTestCase;

import java.util.Optional;

public class HttpServiceImplementationServerFactoryTestCase extends ServerFactoryIsolationTestCase {

  private static final String MULE_CONTEXT_ID = "muleContextId";

  public HttpServiceImplementationServerFactoryTestCase(String serviceToLoad) {
    super(HttpServiceImplementation.class.getName());
  }

  protected void assertServerFactory(HttpServerFactory serverFactory, String contextName, Optional<String> parentContext) {
    assertThat(((ContextHttpServerFactoryAdapter) serverFactory).getContext(), is(contextName));
    assertThat(((ContextHttpServerFactoryAdapter) serverFactory).getParentContext(), is(parentContext.orElse(null)));
  }

  protected HttpServerFactory newServerFactory(Optional<String> artifactName, Optional<String> domainName,
                                               ArtifactType artifactType) {
    MuleConfiguration muleConfiguration = mock(MuleConfiguration.class);
    when(muleConfiguration.getShutdownTimeout()).thenReturn(valueOf(20));

    MuleContext muleContext = mock(MuleContext.class);
    when(muleContext.getArtifactType()).thenReturn(artifactType);
    when(muleContext.getConfiguration()).thenReturn(muleConfiguration);
    when(muleContext.getId()).thenReturn(MULE_CONTEXT_ID);

    Registry registry = mock(Registry.class);

    when(registry.<String>lookupByName(APP_NAME_PROPERTY)).thenReturn(artifactName);
    when(registry.<String>lookupByName(DOMAIN_NAME_PROPERTY)).thenReturn(domainName);

    return ((HttpServiceImplementation) service).getServerFactory(registry, muleContext);
  }
}
