/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.client;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.AsyncHttpClientConfigDefaults;
import com.ning.http.client.AsyncHttpProvider;
import com.ning.http.client.AsyncHttpProviderConfig;
import com.ning.http.client.BodyDeferringAsyncHandler;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.MaxRedirectException;
import com.ning.http.client.ProxyServer;
import com.ning.http.client.Realm;
import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.Response;
import com.ning.http.client.filter.FilterException;
import com.ning.http.client.filter.RequestFilter;
import com.ning.http.client.providers.grizzly.GrizzlyAsyncHttpProvider;
import com.ning.http.client.providers.grizzly.GrizzlyAsyncHttpProviderConfig;
import com.ning.http.client.uri.Uri;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.SSLContext;
import org.mule.runtime.api.config.Feature;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.config.MuleRuntimeFeature;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.api.tls.TlsContextTrustStoreConfiguration;
import org.mule.runtime.api.util.DataUnit;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.client.proxy.ProxyConfig;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.server.HttpServerProperties;
import org.mule.runtime.http.api.tcp.TcpClientSocketProperties;
import org.mule.service.http.impl.service.client.CompositeTransportCustomizer;
import org.mule.service.http.impl.service.client.CustomTimeoutThrottleRequestFilter;
import org.mule.service.http.impl.service.client.GrizzlyRequestConfigurer;
import org.mule.service.http.impl.service.client.HttpResponseCreator;
import org.mule.service.http.impl.service.client.IOStrategyTransportCustomizer;
import org.mule.service.http.impl.service.client.LoggerTransportCustomizer;
import org.mule.service.http.impl.service.client.NonBlockingStreamWriter;
import org.mule.service.http.impl.service.client.RequestHeaderPopulator;
import org.mule.service.http.impl.service.client.SocketConfigTransportCustomizer;
import org.mule.service.http.impl.service.client.async.PreservingClassLoaderAsyncHandler;
import org.mule.service.http.impl.service.client.async.ResponseAsyncHandler;
import org.mule.service.http.impl.service.client.async.ResponseBodyDeferringAsyncHandler;
import org.mule.service.http.impl.service.util.RedirectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrizzlyHttpClient
implements HttpClient {
    private static final int DEFAULT_SELECTOR_THREAD_COUNT = Integer.getInteger(GrizzlyHttpClient.class.getName() + ".DEFAULT_SELECTOR_THREAD_COUNT", Integer.max(Runtime.getRuntime().availableProcessors(), 2));
    private static final int MAX_CONNECTION_LIFETIME = 1800000;
    public static final String HOST_SEPARATOR = ",";
    private static final int DEFAULT_SEND_AND_DEFER_BUFFER_SIZE = DataUnit.KB.toBytes(10);
    private static final String DEFAULT_DECOMPRESS_PROPERTY_NAME = "mule.http.client.decompress";
    private static final String ENABLE_REQUEST_STREAMING_PROPERTY_NAME = "mule.http.requestStreaming.enable";
    private static boolean requestStreamingEnabled = Boolean.parseBoolean(System.getProperty("mule.http.requestStreaming.enable", "true"));
    private static final int DEFAULT_REQUEST_STREAMING_BUFFER_SIZE = 8192;
    private static final String REQUEST_STREAMING_BUFFER_LEN_PROPERTY_NAME = "mule.http.requestStreaming.bufferSize";
    private static int requestStreamingBufferSize = Integer.getInteger("mule.http.requestStreaming.bufferSize", 8192);
    public static int MAX_REDIRECTS = AsyncHttpClientConfigDefaults.defaultMaxRedirects();
    private static final String USE_WORKERS_FOR_STREAMING_PROPERTY_NAME = "mule.http.responseStreaming.useWorkers";
    private static final boolean useWorkersForStreaming = Boolean.parseBoolean(System.getProperty("mule.http.responseStreaming.useWorkers", "true"));
    private static final String MAX_STREAMING_WORKERS_PROPERTY_NAME = "mule.http.responseStreaming.maxWorkers";
    private static int maxStreamingWorkers = Integer.parseInt(System.getProperty("mule.http.responseStreaming.maxWorkers", "-1"));
    private static final String STREAMING_WORKERS_QUEUE_SIZE_PROPERTY_NAME = "mule.http.responseStreaming.queueSize";
    private static int streamingWorkersQueueSize = Integer.parseInt(System.getProperty("mule.http.responseStreaming.queueSize", "-1"));
    private static final int DEFAULT_STREAMING_WORKERS_QUEUE_SIZE = GrizzlyHttpClient.getDefaultStreamingWorkersQueueSize();
    public static final String CUSTOM_MAX_HTTP_PACKET_HEADER_SIZE = "mule.http.client.headerSectionSize";
    private static boolean enableMuleRedirect = Boolean.parseBoolean(System.getProperty("mule.http.enableMuleRedirect", "true"));
    private static final String MAX_CLIENT_REQUEST_HEADERS_KEY = "mule.http.MAX_CLIENT_REQUEST_HEADERS";
    private static int MAX_CLIENT_REQUEST_HEADERS = Integer.getInteger("mule.http.MAX_CLIENT_REQUEST_HEADERS", 100);
    private static final Logger LOGGER = LoggerFactory.getLogger(GrizzlyHttpClient.class);
    private static boolean DEFAULT_DECOMPRESS = Boolean.getBoolean("mule.http.client.decompress");
    private final TlsContextFactory tlsContextFactory;
    private final ProxyConfig proxyConfig;
    private final TcpClientSocketProperties clientSocketProperties;
    private final int maxConnections;
    private final boolean usePersistentConnections;
    private final int connectionIdleTimeout;
    private final boolean streamingEnabled;
    private final int responseBufferSize;
    private final String name;
    private final boolean decompressionEnabled;
    private final NonBlockingStreamWriter nonBlockingStreamWriter;
    private Scheduler selectorScheduler;
    private Scheduler workerScheduler;
    private SchedulerService schedulerService;
    private final SchedulerConfig schedulersConfig;
    protected AsyncHttpClient asyncHttpClient;
    private SSLContext sslContext;
    private final HttpResponseCreator httpResponseCreator = new HttpResponseCreator();
    private final TlsContextFactory defaultTlsContextFactory = TlsContextFactory.builder().buildDefault();
    private final RedirectUtils redirectUtils;
    private static final boolean isStrict302Handling = AsyncHttpClientConfigDefaults.defaultStrict302Handling();
    private final RequestHeaderPopulator headerPopulator;
    private final FeatureFlaggingService featureFlaggingService;

    public GrizzlyHttpClient(HttpClientConfiguration config, SchedulerService schedulerService, SchedulerConfig schedulersConfig, FeatureFlaggingService featureFlaggingService) {
        this.tlsContextFactory = config.getTlsContextFactory();
        this.proxyConfig = config.getProxyConfig();
        this.clientSocketProperties = config.getClientSocketProperties();
        this.maxConnections = config.getMaxConnections();
        this.usePersistentConnections = config.isUsePersistentConnections();
        this.connectionIdleTimeout = config.getConnectionIdleTimeout();
        this.streamingEnabled = config.isStreaming();
        this.responseBufferSize = config.getResponseBufferSize();
        this.decompressionEnabled = config.isDecompress() != null ? config.isDecompress() : DEFAULT_DECOMPRESS;
        this.name = config.getName();
        this.schedulerService = schedulerService;
        this.schedulersConfig = schedulersConfig;
        this.redirectUtils = new RedirectUtils(isStrict302Handling, HttpServerProperties.PRESERVE_HEADER_CASE);
        this.headerPopulator = new RequestHeaderPopulator(this.usePersistentConnections);
        this.nonBlockingStreamWriter = new NonBlockingStreamWriter();
        this.featureFlaggingService = featureFlaggingService;
    }

    public void start() {
        this.selectorScheduler = this.schedulerService.customScheduler(this.schedulersConfig.withDirectRunCpuLightWhenTargetBusy(true).withMaxConcurrentTasks(DEFAULT_SELECTOR_THREAD_COUNT).withName(this.name), DEFAULT_SELECTOR_THREAD_COUNT);
        this.workerScheduler = this.getWorkerScheduler(this.schedulersConfig.withName(this.name + ".requester.workers"));
        if (this.streamingEnabled && this.nonBlockingStreamWriter.isEnabled()) {
            this.workerScheduler.submit((Runnable)this.nonBlockingStreamWriter);
        }
        AsyncHttpClientConfig.Builder builder = new AsyncHttpClientConfig.Builder();
        builder.setAllowPoolingConnections(true);
        builder.setMaxRequestHeaders(MAX_CLIENT_REQUEST_HEADERS);
        this.configureTransport(builder);
        this.configureTlsContext(builder);
        this.configureProxy(builder);
        this.configureConnections(builder);
        builder.setNtlmAvoidSendPayloadOnType1(this.featureFlaggingService.isEnabled((Feature)MuleRuntimeFeature.NTLM_AVOID_SEND_PAYLOAD_ON_TYPE_1));
        AsyncHttpClientConfig config = builder.build();
        this.asyncHttpClient = new AsyncHttpClient((AsyncHttpProvider)new GrizzlyAsyncHttpProvider(config), config);
    }

    private Scheduler getWorkerScheduler(SchedulerConfig config) {
        if (this.streamingEnabled && useWorkersForStreaming) {
            return this.schedulerService.customScheduler(config.withMaxConcurrentTasks(this.getMaxStreamingWorkers()), this.getStreamingWorkersQueueSize());
        }
        return this.schedulerService.ioScheduler(config);
    }

    private int getMaxStreamingWorkers() {
        return maxStreamingWorkers > 0 ? maxStreamingWorkers : DEFAULT_SELECTOR_THREAD_COUNT * 4;
    }

    private int getStreamingWorkersQueueSize() {
        return streamingWorkersQueueSize > 0 ? streamingWorkersQueueSize : DEFAULT_STREAMING_WORKERS_QUEUE_SIZE;
    }

    private static int getDefaultStreamingWorkersQueueSize() {
        int cores = Runtime.getRuntime().availableProcessors();
        long memoryInKB = Runtime.getRuntime().maxMemory() / 1024L;
        return (int)Math.max(2L, (long)cores + (memoryInKB - 245760L) / 5120L);
    }

    private void configureTlsContext(AsyncHttpClientConfig.Builder builder) {
        TlsContextFactory resolvedTlsContextFactory;
        if (this.tlsContextFactory != null) {
            resolvedTlsContextFactory = this.tlsContextFactory;
            try {
                this.sslContext = this.tlsContextFactory.createSslContext();
            }
            catch (Exception e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Cannot initialize SSL context"), (Throwable)e);
            }
            builder.setSSLContext(this.sslContext);
            TlsContextTrustStoreConfiguration trustStoreConfiguration = this.tlsContextFactory.getTrustStoreConfiguration();
            if (trustStoreConfiguration != null && trustStoreConfiguration.isInsecure()) {
                LOGGER.warn(String.format("TLS configuration for client %s has been set to use an insecure trust store. This means no certificate validations will be performed, rendering connections vulnerable to attacks. Use at own risk.", this.name));
                builder.setAcceptAnyCertificate(true);
            }
        } else {
            resolvedTlsContextFactory = this.defaultTlsContextFactory;
        }
        if (resolvedTlsContextFactory.getEnabledCipherSuites() != null) {
            builder.setEnabledCipherSuites(resolvedTlsContextFactory.getEnabledCipherSuites());
        }
        if (resolvedTlsContextFactory.getEnabledProtocols() != null) {
            builder.setEnabledProtocols(resolvedTlsContextFactory.getEnabledProtocols());
        }
    }

    private void configureProxy(AsyncHttpClientConfig.Builder builder) {
        if (this.proxyConfig != null) {
            this.doConfigureProxy(builder, this.proxyConfig);
        }
    }

    protected void doConfigureProxy(AsyncHttpClientConfig.Builder builder, ProxyConfig proxyConfig) {
        builder.setProxyServer(this.buildProxy(proxyConfig));
    }

    ProxyServer buildProxy(ProxyConfig proxyConfig) {
        ProxyServer proxyServer;
        if (!StringUtils.isEmpty((String)proxyConfig.getUsername())) {
            proxyServer = new ProxyServer(proxyConfig.getHost(), proxyConfig.getPort(), proxyConfig.getUsername(), proxyConfig.getPassword());
            if (proxyConfig instanceof ProxyConfig.NtlmProxyConfig) {
                proxyServer.setNtlmDomain(((ProxyConfig.NtlmProxyConfig)proxyConfig).getNtlmDomain());
                try {
                    proxyServer.setNtlmHost(this.getHostName());
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
                proxyServer.setScheme(Realm.AuthScheme.NTLM);
            }
        } else {
            proxyServer = new ProxyServer(proxyConfig.getHost(), proxyConfig.getPort());
        }
        if (proxyConfig.getNonProxyHosts() != null && !proxyConfig.getNonProxyHosts().isEmpty()) {
            for (String host : proxyConfig.getNonProxyHosts().split(HOST_SEPARATOR)) {
                proxyServer.addNonProxyHost(host.trim());
            }
        }
        return proxyServer;
    }

    private void configureTransport(AsyncHttpClientConfig.Builder builder) {
        GrizzlyAsyncHttpProviderConfig providerConfig = new GrizzlyAsyncHttpProviderConfig();
        boolean tlsEnabled = this.tlsContextFactory != null;
        CompositeTransportCustomizer compositeTransportCustomizer = new CompositeTransportCustomizer();
        compositeTransportCustomizer.addTransportCustomizer(new IOStrategyTransportCustomizer((ExecutorService)this.selectorScheduler, (ExecutorService)this.workerScheduler, this.streamingEnabled, DEFAULT_SELECTOR_THREAD_COUNT, tlsEnabled));
        compositeTransportCustomizer.addTransportCustomizer(new LoggerTransportCustomizer(this.name));
        if (this.clientSocketProperties != null) {
            compositeTransportCustomizer.addTransportCustomizer(new SocketConfigTransportCustomizer(this.clientSocketProperties));
            builder.setConnectTimeout(this.clientSocketProperties.getConnectionTimeout().intValue());
        }
        providerConfig.addProperty(GrizzlyAsyncHttpProviderConfig.Property.TRANSPORT_CUSTOMIZER, (Object)compositeTransportCustomizer);
        providerConfig.addProperty(GrizzlyAsyncHttpProviderConfig.Property.DECOMPRESS_RESPONSE, (Object)this.decompressionEnabled);
        providerConfig.addProperty(GrizzlyAsyncHttpProviderConfig.Property.MAX_HTTP_PACKET_HEADER_SIZE, (Object)this.retrieveMaximumHeaderSectionSize());
        builder.setAsyncHttpClientProviderConfig((AsyncHttpProviderConfig)providerConfig);
    }

    private void configureConnections(AsyncHttpClientConfig.Builder builder) {
        if (this.maxConnections > 0) {
            builder.addRequestFilter((RequestFilter)new CustomTimeoutThrottleRequestFilter(this.maxConnections));
        }
        builder.setMaxConnections(this.maxConnections);
        builder.setMaxConnectionsPerHost(this.maxConnections);
        builder.setAllowPoolingConnections(this.usePersistentConnections);
        builder.setAllowPoolingSslConnections(this.usePersistentConnections);
        builder.setConnectionTTL(1800000);
        builder.setPooledConnectionIdleTimeout(this.connectionIdleTimeout);
        builder.setIOThreadMultiplier(1);
    }

    public HttpResponse send(HttpRequest request, HttpRequestOptions options) throws IOException, TimeoutException {
        Preconditions.checkState((this.asyncHttpClient != null ? 1 : 0) != 0, (String)"The client must be started before use.");
        if (this.streamingEnabled) {
            return this.sendAndDefer(request, this.createGrizzlyRequest(request, options), options, 0);
        }
        return this.sendAndWait(request, this.createGrizzlyRequest(request, options), options, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse sendAndDefer(HttpRequest request, Request grizzlyRequest, HttpRequestOptions options, int currentRedirects) throws IOException, TimeoutException {
        PipedOutputStream outPipe = new PipedOutputStream();
        PipedInputStream inPipe = new PipedInputStream(outPipe, this.responseBufferSize > 0 ? this.responseBufferSize : DEFAULT_SEND_AND_DEFER_BUFFER_SIZE);
        BodyDeferringAsyncHandler asyncHandler = new BodyDeferringAsyncHandler((OutputStream)outPipe);
        this.asyncHttpClient.executeRequest(grizzlyRequest, (AsyncHandler)asyncHandler);
        try {
            Response response = asyncHandler.getResponse();
            HttpResponse httpResponse = this.httpResponseCreator.create(response, inPipe);
            if (this.redirectUtils.shouldFollowRedirect(httpResponse, options, enableMuleRedirect)) {
                if (currentRedirects >= MAX_REDIRECTS) {
                    throw new IOException("Max redirects exceeded", (Throwable)new MaxRedirectException());
                }
                HttpRequest redirectRequest = null;
                try {
                    redirectRequest = this.redirectUtils.createRedirectRequest(httpResponse, request, options);
                    httpResponse = this.sendAndDefer(redirectRequest, this.createGrizzlyRedirectRequest(redirectRequest, httpResponse, options), options, currentRedirects + 1);
                    this.onCompleteRedirect(redirectRequest);
                }
                catch (Throwable throwable) {
                    this.onCompleteRedirect(redirectRequest);
                    throw throwable;
                }
            }
            return httpResponse;
        }
        catch (IOException e) {
            if (e.getCause() instanceof TimeoutException) {
                throw (TimeoutException)e.getCause();
            }
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException(e);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse sendAndWait(HttpRequest request, Request grizzlyRequest, HttpRequestOptions options, int currentRedirects) throws IOException, TimeoutException {
        ListenableFuture future = this.asyncHttpClient.executeRequest(grizzlyRequest);
        try {
            HttpResponse httpResponse;
            Response response = (Response)future.get();
            if (response == null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Null response returned by async client");
                }
                response = (Response)future.get();
            }
            if (this.redirectUtils.shouldFollowRedirect(httpResponse = this.httpResponseCreator.create(response, response.getResponseBodyAsStream()), options, enableMuleRedirect)) {
                if (currentRedirects >= MAX_REDIRECTS) {
                    throw new IOException("Max redirects exceeded", (Throwable)new MaxRedirectException());
                }
                HttpRequest redirectRequest = null;
                try {
                    redirectRequest = this.redirectUtils.createRedirectRequest(httpResponse, request, options);
                    httpResponse = this.sendAndWait(redirectRequest, this.createGrizzlyRedirectRequest(redirectRequest, httpResponse, options), options, currentRedirects + 1);
                    this.onCompleteRedirect(redirectRequest);
                }
                catch (Throwable throwable) {
                    this.onCompleteRedirect(redirectRequest);
                    throw throwable;
                }
            }
            return httpResponse;
        }
        catch (InterruptedException e) {
            throw new IOException(e.getMessage(), e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof TimeoutException) {
                throw (TimeoutException)e.getCause();
            }
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            if (e.getCause() instanceof FilterException) {
                throw new IOException(e.getCause().getMessage(), e.getCause());
            }
            throw new IOException(e.getMessage(), e);
        }
    }

    public CompletableFuture<HttpResponse> sendAsync(HttpRequest request, HttpRequestOptions options) {
        Preconditions.checkState((this.asyncHttpClient != null ? 1 : 0) != 0, (String)"The client must be started before use.");
        try {
            return this.sendAsync(request, this.createGrizzlyRequest(request, options), options, 0);
        }
        catch (Throwable e) {
            CompletableFuture<HttpResponse> ex = new CompletableFuture<HttpResponse>();
            ex.completeExceptionally(e);
            return ex;
        }
    }

    private CompletableFuture<HttpResponse> sendAsync(HttpRequest request, Request grizzlyRequest, HttpRequestOptions options, int currentRedirects) {
        CompletableFuture<HttpResponse> future = new CompletableFuture<HttpResponse>();
        try {
            CompletableFuture<HttpResponse> auxFuture = new CompletableFuture<HttpResponse>();
            PreservingClassLoaderAsyncHandler<Object> asyncHandler = this.streamingEnabled ? new PreservingClassLoaderAsyncHandler<Response>(new ResponseBodyDeferringAsyncHandler(auxFuture, this.responseBufferSize, (ExecutorService)this.workerScheduler, this.nonBlockingStreamWriter)) : new PreservingClassLoaderAsyncHandler(new ResponseAsyncHandler(auxFuture));
            auxFuture.whenComplete((response, exception) -> {
                if (response != null) {
                    if (this.redirectUtils.shouldFollowRedirect((HttpResponse)response, options, enableMuleRedirect)) {
                        try {
                            this.handleRedirectAsync(request, (HttpResponse)response, options, currentRedirects, future);
                        }
                        catch (Throwable e) {
                            future.completeExceptionally(e);
                        }
                    } else {
                        future.complete((HttpResponse)response);
                    }
                } else {
                    future.completeExceptionally((Throwable)exception);
                }
            });
            this.asyncHttpClient.executeRequest(grizzlyRequest, asyncHandler);
        }
        catch (Exception e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    protected void onCompleteRedirect(HttpRequest redirectRequest) {
    }

    private void handleRedirectAsync(HttpRequest request, HttpResponse response, HttpRequestOptions options, int currentRedirects, CompletableFuture<HttpResponse> future) throws IOException {
        if (currentRedirects >= MAX_REDIRECTS) {
            future.completeExceptionally((Throwable)new MaxRedirectException());
            return;
        }
        HttpRequest redirectRequest = this.redirectUtils.createRedirectRequest(response, request, options);
        Request grizzlyRequest = this.createGrizzlyRedirectRequest(redirectRequest, response, options);
        this.sendAsync(redirectRequest, grizzlyRequest, options, currentRedirects + 1).whenComplete((redirectResponse, redirectException) -> {
            if (redirectResponse != null) {
                future.complete((HttpResponse)redirectResponse);
            } else {
                future.completeExceptionally((Throwable)redirectException);
            }
            this.onCompleteRedirect(redirectRequest);
        });
    }

    private Request createGrizzlyRedirectRequest(HttpRequest request, HttpResponse response, HttpRequestOptions options) throws IOException {
        RequestBuilder reqBuilder = this.createGrizzlyRequestBuilder(request, options);
        this.redirectUtils.handleResponseCookies(reqBuilder, response);
        return reqBuilder.build();
    }

    protected Request createGrizzlyRequest(HttpRequest request, HttpRequestOptions options) throws IOException {
        return this.createGrizzlyRequestBuilder(request, options).build();
    }

    private RequestBuilder createGrizzlyRequestBuilder(HttpRequest request, HttpRequestOptions options) throws IOException {
        RequestBuilder reqBuilder = this.createRequestBuilder(request, options, new GrizzlyRequestConfigurer(this, options, request, enableMuleRedirect, requestStreamingEnabled, requestStreamingBufferSize));
        URI uri = request.getUri();
        if (uri.getScheme() == null) {
            throw new IllegalArgumentException("The uri provided '" + String.valueOf(uri) + "' must contain a scheme.");
        }
        if (uri.getHost() == null) {
            throw new IllegalArgumentException("The uri provided '" + String.valueOf(uri) + "' must contain a host.");
        }
        reqBuilder.setUri(new Uri(uri.getScheme(), uri.getRawUserInfo(), uri.getHost(), uri.getPort(), uri.getRawPath(), uri.getRawQuery() != null ? uri.getRawQuery() + (request.getQueryParams().isEmpty() ? "" : "&") : null));
        return reqBuilder;
    }

    protected RequestBuilder createRequestBuilder(HttpRequest request, HttpRequestOptions options, RequestConfigurer requestConfigurer) throws IOException {
        RequestBuilder requestBuilder = new RequestBuilder(request.getMethod(), true);
        requestConfigurer.configure(requestBuilder);
        return requestBuilder;
    }

    protected void populateHeaders(HttpRequest request, RequestBuilder builder) {
        this.headerPopulator.populateHeaders(request, builder);
    }

    String getHostName() throws UnknownHostException {
        return InetAddress.getLocalHost().getHostName();
    }

    protected ProxyConfig getProxyConfig() {
        return this.proxyConfig;
    }

    public void stop() {
        this.asyncHttpClient.close();
        this.nonBlockingStreamWriter.stop();
        this.workerScheduler.stop();
        this.selectorScheduler.stop();
    }

    public static void refreshSystemProperties() {
        DEFAULT_DECOMPRESS = Boolean.getBoolean(DEFAULT_DECOMPRESS_PROPERTY_NAME);
        MAX_CLIENT_REQUEST_HEADERS = Integer.getInteger(MAX_CLIENT_REQUEST_HEADERS_KEY, 100);
        enableMuleRedirect = Boolean.parseBoolean(System.getProperty("mule.http.enableMuleRedirect", "true"));
    }

    private int retrieveMaximumHeaderSectionSize() {
        try {
            return Integer.valueOf(System.getProperty(CUSTOM_MAX_HTTP_PACKET_HEADER_SIZE, String.valueOf(8192)));
        }
        catch (NumberFormatException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Invalid value '%s' for '%s' configuration.", System.getProperty(CUSTOM_MAX_HTTP_PACKET_HEADER_SIZE), CUSTOM_MAX_HTTP_PACKET_HEADER_SIZE)), (Throwable)e);
        }
    }

    @FunctionalInterface
    protected static interface RequestConfigurer {
        public void configure(RequestBuilder var1) throws IOException;
    }
}

