/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.functional.client;

import io.qameta.allure.Description;
import io.qameta.allure.Issue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.service.http.impl.functional.AbstractHttpServiceTestCase;
import org.mule.service.http.impl.util.SchedulerAdapter;
import org.mule.service.http.impl.util.SchedulerServiceAdapter;
import org.mule.tck.SimpleUnitTestSupportSchedulerService;
import org.mule.tck.probe.JUnitLambdaProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;

@Issue(value="MULE-19774")
public class GrizzlyHttpClientSchedulerTestCase
extends AbstractHttpServiceTestCase {
    private final SchedulerService basicSchedulerService = new SimpleUnitTestSupportSchedulerService();
    private final LazyValue<CountingExecutesScheduler> selectorsScheduler = new LazyValue(this::createSelectorsScheduler);
    private final LazyValue<SchedulerService> decoratedSchedulerService = new LazyValue(this::createDecoratedSchedulerService);
    private static final PollingProber PROBER = new PollingProber();
    private Latch lockLatch;
    private Latch previousTaskScheduled;
    private HttpClient httpClient;

    public GrizzlyHttpClientSchedulerTestCase(String serviceName) {
        super(serviceName);
    }

    @Before
    public void initialize() throws Exception {
        this.lockLatch = new Latch();
        this.previousTaskScheduled = new Latch();
        this.httpClient = this.service.getClientFactory().create(new HttpClientConfiguration.Builder().setName("http-client-scheduler").build());
    }

    private CountingExecutesScheduler createSelectorsScheduler() {
        return new CountingExecutesScheduler(this.basicSchedulerService.customScheduler(SchedulerConfig.config().withDirectRunCpuLightWhenTargetBusy(true).withMaxConcurrentTasks(1).withName("TestSelectorsScheduler")));
    }

    private SchedulerService createDecoratedSchedulerService() {
        return new SchedulerServiceAdapter(this.basicSchedulerService){

            public Scheduler customScheduler(SchedulerConfig config, int queueSize) {
                return (Scheduler)GrizzlyHttpClientSchedulerTestCase.this.selectorsScheduler.get();
            }
        };
    }

    @Override
    public SchedulerService getSchedulerService() {
        return (SchedulerService)this.decoratedSchedulerService.get();
    }

    @Test
    @Description(value="Start the pool with an scheduler running a blocked task. The selector pool should success to start sending one task to the queue.")
    public void testSchedulerWithNonFinishTask() throws ExecutionException, InterruptedException, TimeoutException {
        Runnable oldTask = () -> {
            try {
                this.previousTaskScheduled.release();
                this.lockLatch.await();
            }
            catch (InterruptedException e) {
                Assert.fail((String)"Fail initializing selector pool");
            }
        };
        ((CountingExecutesScheduler)((Object)this.selectorsScheduler.get())).execute(oldTask);
        this.previousTaskScheduled.await();
        Scheduler startScheduler = this.basicSchedulerService.customScheduler(SchedulerConfig.config().withDirectRunCpuLightWhenTargetBusy(true).withMaxConcurrentTasks(1).withName("TestStartScheduler"));
        startScheduler.submit(() -> this.httpClient.start()).get(5L, TimeUnit.SECONDS);
        Assert.assertThat((Object)((CountingExecutesScheduler)((Object)this.selectorsScheduler.get())).getStartedCommands(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((CountingExecutesScheduler)((Object)this.selectorsScheduler.get())).getFinishedCommands(), (Matcher)CoreMatchers.is((Object)0));
        this.lockLatch.release();
        PROBER.check((Probe)new JUnitLambdaProbe(() -> ((CountingExecutesScheduler)((Object)((Object)this.selectorsScheduler.get()))).getStartedCommands() == 2 && ((CountingExecutesScheduler)((Object)((Object)this.selectorsScheduler.get()))).getFinishedCommands() == 1));
    }

    private static class CountingExecutesScheduler
    extends SchedulerAdapter {
        private final AtomicInteger startedCommands = new AtomicInteger();
        private final AtomicInteger finishedCommands = new AtomicInteger();

        public CountingExecutesScheduler(Scheduler schedulerDelegate) {
            super(schedulerDelegate);
        }

        public void execute(Runnable command) {
            super.execute(() -> {
                this.startedCommands.incrementAndGet();
                try {
                    command.run();
                }
                finally {
                    this.finishedCommands.incrementAndGet();
                }
            });
        }

        public int getStartedCommands() {
            return this.startedCommands.get();
        }

        public int getFinishedCommands() {
            return this.finishedCommands.get();
        }
    }
}

