/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.functional.client;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.CodeSource;
import org.apache.commons.io.FileUtils;
import org.junit.After;
import org.junit.Before;
import org.mule.service.http.impl.service.client.GrizzlyHttpClient;

public class RequestStreamingLargePayloadTestCase
extends org.mule.service.http.test.common.client.RequestStreamingLargePayloadTestCase {
    public RequestStreamingLargePayloadTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    @Before
    public void before() throws Exception {
        RequestStreamingLargePayloadTestCase.setRequestStreaming(true);
    }

    @After
    public void after() throws Exception {
        RequestStreamingLargePayloadTestCase.setRequestStreaming(false);
    }

    protected InputStream getInputStream() {
        try {
            return Files.newInputStream(Paths.get(URI.create(String.valueOf(RequestStreamingLargePayloadTestCase.getClassPathRoot(RequestStreamingLargePayloadTestCase.class).toURI()) + "largePayload")), new OpenOption[0]);
        }
        catch (Exception e) {
            throw new AssertionError((Object)"Error on loading the large payload file");
        }
    }

    protected String expectedPayload() {
        try {
            return FileUtils.readFileToString((File)new File(RequestStreamingLargePayloadTestCase.getClassPathRoot(RequestStreamingLargePayloadTestCase.class).getPath() + "largePayload"), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new AssertionError((Object)"Error on loading the large payload file");
        }
    }

    public static void setRequestStreaming(boolean requestStreaming) throws Exception {
        Field requestStreamingEnabledField = GrizzlyHttpClient.class.getDeclaredField("requestStreamingEnabled");
        requestStreamingEnabledField.setAccessible(true);
        requestStreamingEnabledField.setBoolean(null, requestStreaming);
    }

    public static URL getClassPathRoot(Class clazz) {
        CodeSource cs = clazz.getProtectionDomain().getCodeSource();
        return cs != null ? cs.getLocation() : null;
    }
}

