/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.functional.server;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mule.service.http.impl.functional.server.HttpServerTransferTestCase;

public class HttpServerTransfer10TestCase
extends HttpServerTransferTestCase {
    public HttpServerTransfer10TestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    @Override
    public HttpVersion getVersion() {
        return HttpVersion.HTTP_1_0;
    }

    @Test
    public void defaultsStreamingWhenEmpty() throws Exception {
        this.verify10Headers("", "close", (Matcher<Object>)Matchers.is((Matcher)Matchers.nullValue()), "");
    }

    @Test
    public void defaultsStreamingWhenBytes() throws Exception {
        this.verify10Headers("/bytes", "close", (Matcher<Object>)Matchers.is((Matcher)Matchers.nullValue()), "My awesome data");
    }

    @Test
    public void defaultsStreamingWhenMultipart() throws Exception {
        this.verify10Headers("/multipart", "close", (Matcher<Object>)Matchers.is((Matcher)Matchers.nullValue()), "--bounds\r\nContent-Type: text/plain\r\nContent-Disposition: form-data; name=\"name\"\r\n\r\nMy awesome data\r\n--bounds--\r\n");
    }

    @Test
    public void defaultsStreamingWhenStream() throws Exception {
        this.verify10Headers("/stream", "close", (Matcher<Object>)Matchers.is((Matcher)Matchers.nullValue()), "My awesome data");
    }

    private void verify10Headers(String path, String expectedConnection, Matcher<Object> contentLengthMatcher, String expectedBody) throws IOException {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpGet httpGet = new HttpGet(this.getUri(path));
            httpGet.setProtocolVersion((ProtocolVersion)this.getVersion());
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);){
                MatcherAssert.assertThat((Object)this.getHeaderValue(response, "Connection"), (Matcher)Matchers.is((Object)expectedConnection));
                MatcherAssert.assertThat((Object)this.getHeaderValue(response, "Content-Length"), contentLengthMatcher);
                MatcherAssert.assertThat((Object)IOUtils.toString((InputStream)response.getEntity().getContent()), (Matcher)Matchers.is((Object)expectedBody));
            }
        }
    }
}

