/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.service.http.impl.functional;

import static org.mule.runtime.http.api.HttpConstants.HttpStatus.OK;
import static org.mule.runtime.http.api.HttpHeaders.Names.UPGRADE;
import static org.mule.service.http.impl.AllureConstants.HttpFeature.HttpStory.LISTENERS;

import static java.nio.charset.StandardCharsets.UTF_8;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.is;

import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.service.http.impl.functional.client.AbstractHttpClientTestCase;

import java.nio.charset.Charset;

import org.apache.commons.io.IOUtils;
import org.apache.http.client.fluent.Request;
import org.apache.http.entity.ContentType;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

import io.qameta.allure.Story;

@Story(LISTENERS)
public class HttpH2CUpgradeRequestTestCase extends AbstractHttpClientTestCase {

  private static final String RESPONSE = "response";

  private static final String REQUEST = "tests";

  private HttpClient client;

  public HttpH2CUpgradeRequestTestCase(String serviceToLoad) {
    super(serviceToLoad);
  }

  @Before
  public void createClient() {
    HttpClientConfiguration clientConf = new HttpClientConfiguration.Builder().setName(getClass().getSimpleName()).build();
    client = service.getClientFactory().create(clientConf);
    client.start();
  }

  @After
  public void closeClient() {
    if (client != null) {
      client.stop();
    }
  }

  @Override
  protected HttpResponse setUpHttpResponse(HttpRequest request) {
    HttpResponseBuilder builder = HttpResponse.builder();
    builder.entity(new ByteArrayHttpEntity(RESPONSE.getBytes()));
    return builder.build();
  }

  @Test
  public void whenSettingUpgradeHeaderDoesNotTimeOut() throws Exception {
    Request request = Request.Post(getUri())
        .bodyString(new String(REQUEST.getBytes()), ContentType.create("text/plain", Charset.forName("UTF-8")))
        .addHeader(UPGRADE, "h2c");
    org.apache.http.HttpResponse response = request.execute().returnResponse();
    assertThat(response.getStatusLine().getStatusCode(), is(OK.getStatusCode()));
    assertThat(IOUtils.toString(response.getEntity().getContent(), UTF_8), is(RESPONSE));
  }

}
