/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.service.http.impl.functional.client;

import org.mule.service.http.impl.service.HttpServiceImplementation;
import org.mule.service.http.impl.service.client.GrizzlyHttpClient;

import java.lang.reflect.Field;

import org.junit.After;
import org.junit.Before;

public class RequestStreamingCursorNtlmHttpClientPostStreamingTestCase
    extends org.mule.service.http.test.common.client.NtlmHttpClientPostStreamingTestCase {

  public RequestStreamingCursorNtlmHttpClientPostStreamingTestCase() {
    super(HttpServiceImplementation.class.getName());
  }

  @Before
  public void before() throws Exception {
    setRequestStreaming(true);
  }

  @After
  public void after() throws Exception {
    setRequestStreaming(false);
  }

  public static void setRequestStreaming(boolean requestStreaming) throws Exception {
    Field requestStreamingEnabledField = GrizzlyHttpClient.class.getDeclaredField("requestStreamingEnabled");
    requestStreamingEnabledField.setAccessible(true);
    requestStreamingEnabledField.setBoolean(null, requestStreaming);
  }

}
