/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.service.http.impl.functional.client;

import static org.mule.service.http.impl.service.server.grizzly.GrizzlyServerManager.ALLOW_PAYLOAD_FOR_UNDEFINED_METHODS;

import org.mule.service.http.impl.service.HttpServiceImplementation;

public abstract class AbstractHttpTransferLengthTestCase
    extends org.mule.service.http.test.common.client.AbstractHttpTransferLengthTestCase {

  protected AbstractHttpTransferLengthTestCase(boolean isAllowPayload) {
    super(HttpServiceImplementation.class.getName(), isAllowPayload);
  }

  @Override
  protected boolean setAllowPayloadForUndefinedMethod(boolean isAllowPayload) {
    boolean defaultIsAllowPayload = ALLOW_PAYLOAD_FOR_UNDEFINED_METHODS;
    ALLOW_PAYLOAD_FOR_UNDEFINED_METHODS = isAllowPayload;

    return defaultIsAllowPayload;
  }

  @Override
  protected void restoreAllowPayloadForUndefinedMethod(boolean defaultIsAllowPayload) {
    ALLOW_PAYLOAD_FOR_UNDEFINED_METHODS = defaultIsAllowPayload;
  }

}
