/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.functional;

import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.mockito.Mockito;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.http.api.server.HttpServerFactory;
import org.mule.service.http.impl.service.HttpServiceImplementation;
import org.mule.service.http.impl.service.server.ContextHttpServerFactoryAdapter;
import org.mule.service.http.test.common.server.ServerFactoryIsolationTestCase;

public class HttpServiceImplementationServerFactoryTestCase
extends ServerFactoryIsolationTestCase {
    private static final String MULE_CONTEXT_ID = "muleContextId";

    public HttpServiceImplementationServerFactoryTestCase(String serviceToLoad) {
        super(HttpServiceImplementation.class.getName());
    }

    protected void assertServerFactory(HttpServerFactory serverFactory, String contextName, Optional<String> parentContext) {
        MatcherAssert.assertThat((Object)((ContextHttpServerFactoryAdapter)serverFactory).getContext(), (Matcher)Matchers.is((Object)contextName));
        MatcherAssert.assertThat((Object)((ContextHttpServerFactoryAdapter)serverFactory).getParentContext(), (Matcher)Matchers.is((Object)parentContext.orElse(null)));
    }

    protected HttpServerFactory newServerFactory(Optional<String> artifactName, Optional<String> domainName, ArtifactType artifactType) {
        MuleConfiguration muleConfiguration = (MuleConfiguration)Mockito.mock(MuleConfiguration.class);
        Mockito.when((Object)muleConfiguration.getShutdownTimeout()).thenReturn((Object)20L);
        MuleContext muleContext = (MuleContext)Mockito.mock(MuleContext.class);
        Mockito.when((Object)muleContext.getArtifactType()).thenReturn((Object)artifactType);
        Mockito.when((Object)muleContext.getConfiguration()).thenReturn((Object)muleConfiguration);
        Mockito.when((Object)muleContext.getId()).thenReturn((Object)MULE_CONTEXT_ID);
        Registry registry = (Registry)Mockito.mock(Registry.class);
        Mockito.when((Object)registry.lookupByName("app.name")).thenReturn(artifactName);
        Mockito.when((Object)registry.lookupByName("domain.name")).thenReturn(domainName);
        return ((HttpServiceImplementation)this.service).getServerFactory(registry, muleContext);
    }
}

