/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.functional.client;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.io.IOUtils;
import org.junit.After;
import org.junit.Before;
import org.mule.service.http.impl.service.HttpServiceImplementation;
import org.mule.service.http.impl.service.client.GrizzlyHttpClient;
import org.mule.tck.util.FileUtils;

public class RequestStreamingLargePayloadTestCase
extends org.mule.service.http.test.common.client.RequestStreamingLargePayloadTestCase {
    public RequestStreamingLargePayloadTestCase() {
        super(HttpServiceImplementation.class.getName());
    }

    @Before
    public void before() throws Exception {
        RequestStreamingLargePayloadTestCase.setRequestStreaming(true);
    }

    @After
    public void after() throws Exception {
        RequestStreamingLargePayloadTestCase.setRequestStreaming(false);
    }

    public static void setRequestStreaming(boolean requestStreaming) throws Exception {
        Field requestStreamingEnabledField = GrizzlyHttpClient.class.getDeclaredField("requestStreamingEnabled");
        requestStreamingEnabledField.setAccessible(true);
        requestStreamingEnabledField.setBoolean(null, requestStreaming);
    }

    protected InputStream getInputStream() {
        try {
            return Files.newInputStream(FileUtils.getClassPathRoot(RequestStreamingLargePayloadTestCase.class).toPath().resolve("largePayload"), new OpenOption[0]);
        }
        catch (Exception e) {
            throw new AssertionError((Object)("Error on loading the large payload file: " + e.toString()));
        }
    }

    protected String expectedPayload() {
        try {
            return IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/largePayload"), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new AssertionError((Object)("Error on loading the large payload file: " + e.toString()));
        }
    }
}

