/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.functional;

import com.github.peterwippermann.junit4.parameterizedsuite.ParameterContext;
import io.qameta.allure.Feature;
import java.util.Collections;
import junit.framework.TestCase;
import org.junit.After;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.service.http.impl.service.HttpServiceImplementation;
import org.mule.tck.SimpleUnitTestSupportSchedulerService;
import org.mule.tck.junit4.AbstractMuleTestCase;

@RunWith(value=Parameterized.class)
@Feature(value="HTTP Service")
public abstract class AbstractHttpServiceTestCase
extends AbstractMuleTestCase {
    public String serviceToLoad;
    protected HttpService service;
    private SchedulerService schedulerService;

    @Parameterized.Parameters(name="{0}")
    public static Iterable<Object[]> params() {
        if (ParameterContext.isParameterSet()) {
            return Collections.singletonList((Object[])ParameterContext.getParameter(Object[].class));
        }
        return Collections.singletonList(new String[]{HttpServiceImplementation.class.getName()});
    }

    public AbstractHttpServiceTestCase(String serviceToLoad) {
        this.serviceToLoad = serviceToLoad;
    }

    @Before
    public void createServices() throws Exception {
        this.schedulerService = this.getSchedulerService();
        this.service = (HttpServiceImplementation)Class.forName(this.serviceToLoad, true, ((Object)((Object)this)).getClass().getClassLoader()).getConstructor(SchedulerService.class).newInstance(this.schedulerService);
        ((HttpServiceImplementation)this.service).start();
    }

    protected SchedulerService getSchedulerService() {
        return new SimpleUnitTestSupportSchedulerService();
    }

    @After
    public void closeServices() throws Exception {
        if (this.service != null) {
            ((HttpServiceImplementation)this.service).stop();
        }
        if (this.schedulerService instanceof Stoppable) {
            ((Stoppable)this.schedulerService).stop();
        }
    }

    protected String urlForPath(HttpServer httpServer, String endpoint) {
        if (endpoint == null) {
            endpoint = "/";
        }
        if (!((String)endpoint).startsWith("/")) {
            endpoint = "/" + (String)endpoint;
        }
        return String.format("http://%s:%s%s", httpServer.getServerAddress().getIp(), httpServer.getServerAddress().getPort(), endpoint);
    }

    public static class IgnoreResponseStatusCallback
    implements ResponseStatusCallback {
        public void responseSendFailure(Throwable throwable) {
            TestCase.fail((String)throwable.getMessage());
        }

        public void responseSendSuccessfully() {
        }
    }
}

