/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.service.http.impl.functional.client;

import static org.mule.tck.util.FileUtils.getClassPathRoot;

import static java.nio.charset.StandardCharsets.UTF_8;
import static java.nio.file.Files.newInputStream;

import org.mule.service.http.impl.service.HttpServiceImplementation;
import org.mule.service.http.impl.service.client.GrizzlyHttpClient;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;

import org.apache.commons.io.IOUtils;
import org.junit.After;
import org.junit.Before;

public class RequestStreamingLargePayloadTestCase
    extends org.mule.service.http.test.common.client.RequestStreamingLargePayloadTestCase {

  public RequestStreamingLargePayloadTestCase() {
    super(HttpServiceImplementation.class.getName());
  }

  @Before
  public void before() throws Exception {
    setRequestStreaming(true);
  }

  @After
  public void after() throws Exception {
    setRequestStreaming(false);
  }

  public static void setRequestStreaming(boolean requestStreaming) throws Exception {
    Field requestStreamingEnabledField = GrizzlyHttpClient.class.getDeclaredField("requestStreamingEnabled");
    requestStreamingEnabledField.setAccessible(true);
    requestStreamingEnabledField.setBoolean(null, requestStreaming);
  }

  @Override
  protected InputStream getInputStream() {
    try {
      // this needs to be rewindable
      return newInputStream(getClassPathRoot(RequestStreamingLargePayloadTestCase.class).toPath().resolve("largePayload"));
    } catch (Exception e) {
      throw new AssertionError("Error on loading the large payload file: " + e.toString());
    }
  }

  @Override
  protected String expectedPayload() {
    try {
      return IOUtils.toString(this.getClass().getResourceAsStream("/largePayload"), UTF_8);
    } catch (IOException e) {
      throw new AssertionError("Error on loading the large payload file: " + e.toString());
    }
  }

}
