/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.service.http.impl.benchmark;

import static java.util.concurrent.TimeUnit.SECONDS;

import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;

@BenchmarkMode(Mode.Throughput)
@OutputTimeUnit(TimeUnit.MILLISECONDS)
@Fork(value = 1, jvmArgsAppend = {
// "-XX:+FlightRecorder",
// "-XX:StartFlightRecording=filename=cpu-profile.jfr,dumponexit=true,settings=<placeholder for your custom jfc>",
})
public class HttpClientBenchmark {

  @Benchmark
  @Threads(-1)
  @Warmup(iterations = 3, time = 5, timeUnit = SECONDS)
  @Measurement(iterations = 10, time = 12, timeUnit = SECONDS)
  public void testHttpRequestWithParameters(Blackhole bh, HttpClientBenchmarkExecutionPlan plan) {
    var futures = new ArrayList<CompletableFuture<Void>>(plan.requestsPerInvocation);
    for (int i = 0; i < plan.requestsPerInvocation; i++) {
      futures.add(plan.testClient.sendTestRequest());
    }

    int successCount = 0;
    for (var f : futures) {
      try {
        bh.consume(f.get());
        successCount += 1;
      } catch (Exception e) {
        throw new RuntimeException("Request execution failed", e);
      }
    }

    plan.totalSuccessfulRequests.addAndGet(successCount);
  }
}

