/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.functional;

import io.qameta.allure.Story;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.hc.client5.http.fluent.Request;
import org.apache.hc.core5.http.ContentType;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.service.http.impl.functional.client.AbstractHttpClientTestCase;

@Story(value="Listeners")
public class HttpH2CUpgradeRequestTestCase
extends AbstractHttpClientTestCase {
    private static final String RESPONSE = "response";
    private static final String REQUEST = "tests";
    private HttpClient client;

    public HttpH2CUpgradeRequestTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    @Before
    public void createClient() {
        HttpClientConfiguration clientConf = new HttpClientConfiguration.Builder().setName(((Object)((Object)this)).getClass().getSimpleName()).build();
        this.client = this.service.getClientFactory().create(clientConf);
        this.client.start();
    }

    @After
    public void closeClient() {
        if (this.client != null) {
            this.client.stop();
        }
    }

    @Override
    protected HttpResponse setUpHttpResponse(HttpRequest request) {
        HttpResponseBuilder builder = HttpResponse.builder();
        builder.entity((HttpEntity)new ByteArrayHttpEntity(RESPONSE.getBytes()));
        return builder.build();
    }

    @Test
    public void whenSettingUpgradeHeaderDoesNotTimeOut() throws Exception {
        Request request = Request.post((String)this.getUri()).bodyString(new String(REQUEST.getBytes()), ContentType.create((String)"text/plain", (Charset)Charset.forName("UTF-8"))).addHeader("Upgrade", "h2c");
        request.execute().handleResponse(response -> {
            MatcherAssert.assertThat((Object)response.getCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
            MatcherAssert.assertThat((Object)IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8), (Matcher)Matchers.is((Object)RESPONSE));
            return null;
        });
    }
}

