/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.functional.server;

import java.net.SocketTimeoutException;
import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.fluent.Request;
import org.apache.hc.core5.util.Timeout;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.service.http.impl.functional.AbstractHttpServiceTestCase;
import org.mule.service.http.impl.functional.server.AbstractHttpServerTestCase;

public class HttpServerClientTimeoutTestCase
extends AbstractHttpServerTestCase {
    private static final int TIMEOUT = 5000;
    private CountDownLatch requestLatch;
    private CountDownLatch responseLatch;

    public HttpServerClientTimeoutTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    @Before
    public void setUp() throws Exception {
        this.requestLatch = new CountDownLatch(1);
        this.responseLatch = new CountDownLatch(1);
        this.setUpServer();
        this.server.addRequestHandler(Collections.singletonList(HttpConstants.Method.GET.name()), "/test", (requestContext, responseCallback) -> {
            try {
                this.requestLatch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            responseCallback.responseReady(((HttpResponseBuilder)((HttpResponseBuilder)HttpResponse.builder().statusCode(Integer.valueOf(HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR.getStatusCode())).entity((HttpEntity)new ByteArrayHttpEntity("Success!".getBytes()))).addHeader("Content-Type", MediaType.TEXT.toRfcString())).build(), (ResponseStatusCallback)new AbstractHttpServiceTestCase.IgnoreResponseStatusCallback(){

                @Override
                public void responseSendSuccessfully() {
                    HttpServerClientTimeoutTestCase.this.responseLatch.countDown();
                }
            });
        });
    }

    @Override
    protected String getServerName() {
        return "client-timeout-test";
    }

    @Test
    public void executingRequestsFinishesOnDispose() throws Exception {
        Request request = Request.get((String)this.urlForPath(this.server, "test")).connectTimeout(Timeout.ofMilliseconds((long)5000L)).responseTimeout(Timeout.ofMilliseconds((long)5000L));
        Assert.assertThrows(SocketTimeoutException.class, () -> ((Request)request).execute());
        this.server.stop();
        Future<?> disposeTask = Executors.newSingleThreadExecutor().submit(() -> {
            this.server.dispose();
            this.server = null;
        });
        this.requestLatch.countDown();
        disposeTask.get(5000L, TimeUnit.MILLISECONDS);
        this.responseLatch.await(5000L, TimeUnit.MILLISECONDS);
    }
}

