/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.service.http.impl.util;

import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.http.api.HttpService;

import java.lang.reflect.InvocationTargetException;

public class ReflectiveServiceFactory {

  public static HttpService createHttpService(String httpServiceClass, SchedulerService schedulerService)
      throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException,
      ClassNotFoundException {
    return (HttpService) Class
        .forName(httpServiceClass, true, ReflectiveServiceFactory.class.getClassLoader())
        .getConstructor(SchedulerService.class).newInstance(schedulerService);
  }
}
