/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.service.http.impl.benchmark;

import static com.github.tomakehurst.wiremock.client.WireMock.aResponse;
import static com.github.tomakehurst.wiremock.client.WireMock.any;
import static com.github.tomakehurst.wiremock.client.WireMock.anyUrl;
import static com.github.tomakehurst.wiremock.core.WireMockConfiguration.wireMockConfig;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.is;

import org.mule.runtime.api.exception.MuleException;
import org.mule.tck.junit5.DynamicPort;

import java.io.IOException;

import com.github.tomakehurst.wiremock.WireMockServer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.openjdk.jmh.infra.Blackhole;

class ClientBenchmarkTestCase {

  @DynamicPort(systemProperty = "serverPort")
  private Integer serverPort;
  private WireMockServer server;

  private HttpClientBenchmarkExecutionPlan plan;
  private Blackhole blackhole;
  private HttpClientBenchmark benchmarkInstance;

  @BeforeEach
  void setup() throws Exception {
    server = new WireMockServer(wireMockConfig().port(serverPort));
    server.start();
    server.stubFor(any(anyUrl())
        .willReturn(aResponse().withStatus(200).withHeader("Content-Type", "application/json").withBody("{}")));

    plan = new HttpClientBenchmarkExecutionPlan();
    plan.serviceConfiguration = HttpClientBenchmarkExecutionPlan.ServiceConfiguration.NETTY_HTTP_2;
    plan.requestConfiguration = HttpClientBenchmarkExecutionPlan.RequestConfiguration.POST_1KB;
    plan.requestsPerInvocation = 40;
    plan.serverPort = serverPort;
    plan.setUp();

    blackhole = new Blackhole("Today's password is swordfish. I understand instantiating Blackholes directly is dangerous.");

    benchmarkInstance = new HttpClientBenchmark();
  }

  @AfterEach
  void tearDown() throws IOException, MuleException {
    plan.tearDown();
    server.stop();
  }

  @Test
  void getRequest() {
    int invocations = 7;
    for (int i = 0; i < invocations; i++) {
      benchmarkInstance.testHttpRequestWithParameters(blackhole, plan);
    }
    assertThat(plan.totalSuccessfulRequests.get(), is(plan.requestsPerInvocation * invocations));
  }
}
