/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.functional.client;

import com.ning.http.client.MaxRedirectException;
import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.service.http.impl.functional.client.AbstractHttpClientTestCase;
import org.mule.service.http.impl.service.HttpServiceImplementation;
import org.mule.service.http.impl.service.client.GrizzlyHttpClient;
import org.mule.tck.junit4.rule.SystemProperty;

@Feature(value="HTTP Service")
@RunWith(value=Parameterized.class)
@Issue(value="MULE-19908")
public class GrizzlyHttpClientMaxRedirectTestCase
extends AbstractHttpClientTestCase {
    @Rule
    public MockitoRule mockitorule = MockitoJUnit.rule();
    @Rule
    public SystemProperty enableRedirect = new SystemProperty("mule.http.enableMuleRedirect", "true");
    private final HttpClientConfiguration.Builder clientBuilder = new HttpClientConfiguration.Builder().setName("max-redirect-test");
    private int currentRedirects;
    private HttpClient client;
    public boolean streamingMode;

    public GrizzlyHttpClientMaxRedirectTestCase(String serviceToLoad, boolean streamingMode) {
        super(serviceToLoad);
        this.streamingMode = streamingMode;
    }

    @Parameterized.Parameters(name="streaming mode: {1}")
    public static Iterable<Object[]> params() {
        return Arrays.asList({HttpServiceImplementation.class.getName(), true}, {HttpServiceImplementation.class.getName(), false});
    }

    @Before
    public void before() {
        GrizzlyHttpClient.refreshSystemProperties();
        this.currentRedirects = 0;
        this.client = this.service.getClientFactory().create(this.clientBuilder.setStreaming(this.streamingMode).build());
        this.client.start();
    }

    @After
    public void stopClient() {
        if (this.client != null) {
            this.client.stop();
        }
    }

    @Test
    public void sendRequestAndFailedWithMaxRedirectException() {
        try {
            this.client.send(this.getRequest());
        }
        catch (Exception e) {
            this.testMaxRedirect(e);
        }
    }

    @Test
    public void sendAsyncRequestAndFailedWithMaxRedirectException() {
        try {
            this.client.sendAsync(this.getRequest()).get();
        }
        catch (Exception e) {
            this.testMaxRedirect(e);
        }
    }

    private void testMaxRedirect(Exception e) {
        Assert.assertThat(e.getCause().getClass(), (Matcher)Matchers.is(MaxRedirectException.class));
        Assert.assertThat((Object)this.currentRedirects, (Matcher)Matchers.is((Object)(GrizzlyHttpClient.MAX_REDIRECTS + 1)));
    }

    private HttpRequest getRequest() {
        return this.getRequest(this.getUri());
    }

    private HttpRequest getRequest(String uri) {
        return HttpRequest.builder().uri(uri).build();
    }

    @Override
    protected HttpResponse setUpHttpResponse(HttpRequest request) {
        ++this.currentRedirects;
        return ((HttpResponseBuilder)HttpResponse.builder().statusCode(Integer.valueOf(HttpConstants.HttpStatus.MOVED_PERMANENTLY.getStatusCode())).reasonPhrase(HttpConstants.HttpStatus.MOVED_PERMANENTLY.getReasonPhrase()).addHeader("Location", this.getUri())).build();
    }
}

