/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.functional.server;

import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import org.apache.commons.io.IOUtils;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.service.http.impl.functional.AbstractHttpServiceTestCase;
import org.mule.service.http.impl.functional.server.AbstractHttpServerTestCase;

public class HttpServerErrorRequestsTestCase
extends AbstractHttpServerTestCase {
    public HttpServerErrorRequestsTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    @Before
    public void setUp() throws Exception {
        this.setUpServer();
        this.server.addRequestHandler(Collections.singletonList(HttpConstants.Method.GET.name()), "/test", (requestContext, responseCallback) -> responseCallback.responseReady(((HttpResponseBuilder)((HttpResponseBuilder)HttpResponse.builder().entity((HttpEntity)new ByteArrayHttpEntity("Success!".getBytes()))).addHeader("Content-Type", MediaType.TEXT.toRfcString())).build(), (ResponseStatusCallback)new AbstractHttpServiceTestCase.IgnoreResponseStatusCallback()));
    }

    @Override
    protected String getServerName() {
        return "errors-test";
    }

    @Test
    public void methodNotAllowed() throws Exception {
        this.verifyErrorResponse((HttpUriRequestBase)new HttpPost(""), "test", HttpConstants.HttpStatus.METHOD_NOT_ALLOWED, "Method not allowed for endpoint: /test");
    }

    @Test
    public void notFound() throws Exception {
        this.verifyErrorResponse((HttpUriRequestBase)new HttpGet(""), "wat", HttpConstants.HttpStatus.NOT_FOUND, "No listener for endpoint: /wat");
    }

    private void verifyErrorResponse(HttpUriRequestBase httpRequest, String path, HttpConstants.HttpStatus expectedStatus, String expectedBody) throws Exception {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            httpRequest.setUri(this.getUri(path));
            try (CloseableHttpResponse response = httpClient.execute((ClassicHttpRequest)httpRequest);){
                MatcherAssert.assertThat((Object)response.getCode(), (Matcher)Matchers.is((Object)expectedStatus.getStatusCode()));
                MatcherAssert.assertThat((Object)response.getReasonPhrase(), (Matcher)Matchers.is((Object)expectedStatus.getReasonPhrase()));
                MatcherAssert.assertThat((Object)response.getFirstHeader("Content-Type").getValue(), (Matcher)Matchers.is((Object)MediaType.TEXT.toRfcString()));
                MatcherAssert.assertThat((Object)IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8), (Matcher)Matchers.is((Object)expectedBody));
            }
        }
    }

    private URI getUri(String path) {
        return URI.create(String.format("http://localhost:%s/%s", this.port.getValue(), path));
    }
}

