/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service;

import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.http.HttpProbe;
import org.mule.runtime.core.api.util.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpMessageLogger
extends HttpProbe.Adapter {
    private final Logger logger;
    private final LoggerType loggerType;
    private final ClassLoader classLoader;

    public HttpMessageLogger(LoggerType loggerType, String identifier, ClassLoader classLoader) {
        this.loggerType = loggerType;
        this.classLoader = classLoader;
        this.logger = LoggerFactory.getLogger((String)(HttpMessageLogger.class.getName() + "." + identifier));
    }

    public void onDataReceivedEvent(Connection connection, Buffer buffer) {
        this.logBuffer(buffer);
    }

    public void onDataSentEvent(Connection connection, Buffer buffer) {
        this.logBuffer(buffer);
    }

    private void logBuffer(Buffer buffer) {
        ClassUtils.withContextClassLoader((ClassLoader)this.classLoader, () -> {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(this.loggerType.name() + "\n" + buffer.toStringContent());
            }
        });
    }

    public static enum LoggerType {
        LISTENER,
        REQUESTER;

    }
}

