/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service;

import com.ning.http.util.AsyncHttpProviderUtils;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.grizzly.CloseReason;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.client.HttpClientFactory;
import org.mule.runtime.http.api.server.HttpServerFactory;
import org.mule.runtime.http.api.utils.RequestMatcherRegistry;
import org.mule.service.http.impl.service.client.HttpClientConnectionManager;
import org.mule.service.http.impl.service.server.ContextHttpServerFactoryAdapter;
import org.mule.service.http.impl.service.server.HttpListenerConnectionManager;
import org.mule.service.http.impl.service.util.DefaultRequestMatcherRegistryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServiceImplementation
implements HttpService,
Startable,
Stoppable {
    private static final Logger logger;
    private static final String CONTAINER_CONTEXT = "container";
    protected final SchedulerService schedulerService;
    private final HttpListenerConnectionManager listenerConnectionManager;
    private final HttpClientConnectionManager clientConnectionManager;

    public HttpServiceImplementation(SchedulerService schedulerService) {
        this.schedulerService = schedulerService;
        this.listenerConnectionManager = this.createListenerConnectionManager(schedulerService);
        this.clientConnectionManager = this.createClientConnectionManager();
    }

    public HttpServerFactory getServerFactory() {
        return new ContextHttpServerFactoryAdapter(CONTAINER_CONTEXT, this.listenerConnectionManager);
    }

    @Inject
    public HttpServerFactory getServerFactory(@Named(value="_muleContext") MuleContext muleContext) {
        return new ContextHttpServerFactoryAdapter(muleContext.getId(), this.listenerConnectionManager);
    }

    public HttpClientFactory getClientFactory() {
        return config -> this.clientConnectionManager.create(config, SchedulerConfig.config());
    }

    @Inject
    public HttpClientFactory getClientFactory(@Named(value="_muleSchedulerBaseConfig") SchedulerConfig schedulersConfig) {
        return config -> this.clientConnectionManager.create(config, schedulersConfig);
    }

    protected HttpClientConnectionManager createClientConnectionManager() {
        return new HttpClientConnectionManager(this.schedulerService);
    }

    protected HttpListenerConnectionManager createListenerConnectionManager(SchedulerService schedulerService) {
        return new HttpListenerConnectionManager(schedulerService, SchedulerConfig.config());
    }

    public RequestMatcherRegistry.RequestMatcherRegistryBuilder getRequestMatcherRegistryBuilder() {
        return new DefaultRequestMatcherRegistryBuilder();
    }

    public String getName() {
        return "HTTP Service";
    }

    public void start() throws MuleException {
        LifecycleUtils.initialiseIfNeeded((Object)this.listenerConnectionManager);
    }

    public void stop() throws MuleException {
        LifecycleUtils.disposeIfNeeded((Object)this.listenerConnectionManager, (Logger)logger);
    }

    static {
        CloseReason locallyClosedReason = CloseReason.LOCALLY_CLOSED_REASON;
        CloseReason remotelyClosedReason = CloseReason.REMOTELY_CLOSED_REASON;
        IOException iOException = AsyncHttpProviderUtils.REMOTELY_CLOSED_EXCEPTION;
        logger = LoggerFactory.getLogger(HttpServiceImplementation.class);
    }
}

