/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.server;

import java.net.UnknownHostException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.core.api.util.NetworkUtils;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.HttpServerConfiguration;
import org.mule.runtime.http.api.server.ServerAddress;
import org.mule.runtime.http.api.server.ServerAlreadyExistsException;
import org.mule.runtime.http.api.server.ServerCreationException;
import org.mule.runtime.http.api.server.ServerNotFoundException;
import org.mule.service.http.impl.config.ContainerTcpServerSocketProperties;
import org.mule.service.http.impl.service.server.ContextHttpServerFactory;
import org.mule.service.http.impl.service.server.DefaultServerAddress;
import org.mule.service.http.impl.service.server.HttpListenerRegistry;
import org.mule.service.http.impl.service.server.HttpServerManager;
import org.mule.service.http.impl.service.server.ServerIdentifier;
import org.mule.service.http.impl.service.server.grizzly.GrizzlyServerManager;

public class HttpListenerConnectionManager
implements ContextHttpServerFactory,
Initialisable,
Disposable {
    protected static final int DEFAULT_SELECTOR_THREAD_COUNT = Integer.getInteger(HttpListenerConnectionManager.class.getName() + ".DEFAULT_SELECTOR_THREAD_COUNT", Integer.max(Runtime.getRuntime().availableProcessors(), 2));
    private static final String LISTENER_THREAD_NAME_PREFIX = "http.listener";
    private final SchedulerService schedulerService;
    private final SchedulerConfig schedulersConfig;
    protected Scheduler selectorScheduler;
    protected Scheduler workerScheduler;
    protected Scheduler idleTimeoutScheduler;
    protected final HttpListenerRegistry httpListenerRegistry = new HttpListenerRegistry();
    private HttpServerManager httpServerManager;
    private AtomicBoolean initialized = new AtomicBoolean(false);

    public HttpListenerConnectionManager(SchedulerService schedulerService, SchedulerConfig schedulersConfig) {
        this.schedulerService = schedulerService;
        this.schedulersConfig = schedulersConfig;
    }

    public void initialise() throws InitialisationException {
        if (this.initialized.getAndSet(true)) {
            return;
        }
        this.selectorScheduler = this.schedulerService.customScheduler(this.schedulersConfig.withMaxConcurrentTasks(DEFAULT_SELECTOR_THREAD_COUNT).withName(LISTENER_THREAD_NAME_PREFIX), 0);
        this.workerScheduler = this.schedulerService.ioScheduler(this.schedulersConfig);
        this.idleTimeoutScheduler = this.schedulerService.ioScheduler(this.schedulersConfig.withName("http.listener.HttpIdleConnectionCloser"));
        this.httpServerManager = this.createServerManager();
    }

    public synchronized void dispose() {
        this.httpServerManager.dispose();
        this.idleTimeoutScheduler.stop();
        this.workerScheduler.stop();
        this.selectorScheduler.stop();
    }

    @Override
    public HttpServer create(HttpServerConfiguration configuration, String context) throws ServerCreationException {
        ServerAddress serverAddress;
        String host = configuration.getHost();
        try {
            serverAddress = this.createServerAddress(host, configuration.getPort());
        }
        catch (UnknownHostException e) {
            throw new ServerCreationException(String.format("Cannot resolve host %s", host), (Throwable)e);
        }
        TlsContextFactory tlsContextFactory = configuration.getTlsContextFactory();
        HttpServer httpServer = tlsContextFactory == null ? this.createServer(serverAddress, configuration.getSchedulerSupplier(), configuration.isUsePersistentConnections(), configuration.getConnectionIdleTimeout(), new ServerIdentifier(context, configuration.getName())) : this.createSslServer(serverAddress, tlsContextFactory, configuration.getSchedulerSupplier(), configuration.isUsePersistentConnections(), configuration.getConnectionIdleTimeout(), new ServerIdentifier(context, configuration.getName()));
        return httpServer;
    }

    @Override
    public HttpServer lookup(ServerIdentifier identifier) throws ServerNotFoundException {
        return this.httpServerManager.lookupServer(identifier);
    }

    public HttpServer createServer(ServerAddress serverAddress, Supplier<Scheduler> schedulerSupplier, boolean usePersistentConnections, int connectionIdleTimeout, ServerIdentifier identifier) throws ServerCreationException {
        if (!this.containsServerFor(serverAddress, identifier)) {
            return this.httpServerManager.createServerFor(serverAddress, schedulerSupplier, usePersistentConnections, connectionIdleTimeout, identifier);
        }
        throw new ServerAlreadyExistsException(serverAddress);
    }

    public boolean containsServerFor(ServerAddress serverAddress, ServerIdentifier identifier) {
        return this.httpServerManager.containsServerFor(serverAddress, identifier);
    }

    public HttpServer createSslServer(ServerAddress serverAddress, TlsContextFactory tlsContext, Supplier<Scheduler> schedulerSupplier, boolean usePersistentConnections, int connectionIdleTimeout, ServerIdentifier identifier) throws ServerCreationException {
        if (!this.containsServerFor(serverAddress, identifier)) {
            return this.httpServerManager.createSslServerFor(tlsContext, schedulerSupplier, serverAddress, usePersistentConnections, connectionIdleTimeout, identifier);
        }
        throw new ServerAlreadyExistsException(serverAddress);
    }

    protected GrizzlyServerManager createServerManager() throws InitialisationException {
        try {
            return new GrizzlyServerManager((ExecutorService)this.selectorScheduler, (ExecutorService)this.workerScheduler, (ExecutorService)this.idleTimeoutScheduler, this.httpListenerRegistry, ContainerTcpServerSocketProperties.loadTcpServerSocketProperties(), DEFAULT_SELECTOR_THREAD_COUNT);
        }
        catch (MuleException e) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"Could not load server socket properties."), (Throwable)e, (Initialisable)this);
        }
    }

    private ServerAddress createServerAddress(String host, int port) throws UnknownHostException {
        return new DefaultServerAddress(NetworkUtils.getLocalHostAddress((String)host), port);
    }
}

