/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.server.grizzly;

import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.nio.transport.TCPNIOServerConnection;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.ssl.SSLFilter;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.MethodRequestMatcher;
import org.mule.runtime.http.api.server.PathAndMethodRequestMatcher;
import org.mule.runtime.http.api.server.RequestHandler;
import org.mule.runtime.http.api.server.RequestHandlerManager;
import org.mule.runtime.http.api.server.ServerAddress;
import org.mule.service.http.impl.service.server.HttpListenerRegistry;
import org.mule.service.http.impl.service.server.grizzly.GrizzlyAddressFilter;
import org.mule.service.http.impl.service.server.grizzly.MuleSslFilter;

public class GrizzlyHttpServer
implements HttpServer,
Supplier<ExecutorService> {
    private final TCPNIOTransport transport;
    private final ServerAddress serverAddress;
    private final HttpListenerRegistry listenerRegistry;
    private TCPNIOServerConnection serverConnection;
    private GrizzlyAddressFilter<SSLFilter> sslFilter;
    private Supplier<Scheduler> schedulerSource;
    private Runnable schedulerDisposer;
    private Scheduler scheduler;
    private boolean stopped = true;
    private boolean stopping;

    public GrizzlyHttpServer(ServerAddress serverAddress, TCPNIOTransport transport, HttpListenerRegistry listenerRegistry, Supplier<Scheduler> schedulerSource, Runnable schedulerDisposer, GrizzlyAddressFilter<SSLFilter> sslFilter) {
        this.serverAddress = serverAddress;
        this.transport = transport;
        this.listenerRegistry = listenerRegistry;
        this.schedulerSource = schedulerSource;
        this.schedulerDisposer = schedulerDisposer;
        this.sslFilter = sslFilter;
    }

    public synchronized HttpServer start() throws IOException {
        this.scheduler = this.schedulerSource != null ? this.schedulerSource.get() : null;
        this.serverConnection = this.transport.bind(this.serverAddress.getIp(), this.serverAddress.getPort());
        this.serverConnection.addCloseListener((closeable, type) -> {
            try {
                this.scheduler.stop();
            }
            finally {
                this.scheduler = null;
            }
            this.schedulerDisposer.run();
        });
        this.stopped = false;
        return this;
    }

    public synchronized HttpServer stop() {
        this.stopping = true;
        try {
            this.transport.unbind((Connection)this.serverConnection);
            GrizzlyHttpServer grizzlyHttpServer = this;
            return grizzlyHttpServer;
        }
        finally {
            this.stopping = false;
            this.stopped = true;
        }
    }

    public void dispose() {
    }

    public ServerAddress getServerAddress() {
        return this.serverAddress;
    }

    public HttpConstants.Protocol getProtocol() {
        return this.sslFilter.hasFilterForAddress(this.getServerAddress()) ? HttpConstants.Protocol.HTTPS : HttpConstants.Protocol.HTTP;
    }

    public boolean isStopping() {
        return this.stopping;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public RequestHandlerManager addRequestHandler(Collection<String> methods, String path, RequestHandler requestHandler) {
        return this.listenerRegistry.addRequestHandler(this, requestHandler, PathAndMethodRequestMatcher.builder().methodRequestMatcher(MethodRequestMatcher.builder(methods).build()).path(path).build());
    }

    public RequestHandlerManager addRequestHandler(String path, RequestHandler requestHandler) {
        return this.listenerRegistry.addRequestHandler(this, requestHandler, PathAndMethodRequestMatcher.builder().methodRequestMatcher(MethodRequestMatcher.acceptAll()).path(path).build());
    }

    @Override
    public ExecutorService get() {
        return this.scheduler;
    }

    public void enableTls(TlsContextFactory tlsContextFactory) {
        this.sslFilter.addFilterForAddress(this.getServerAddress(), MuleSslFilter.createSslFilter(tlsContextFactory));
    }

    public void disableTls() {
        this.sslFilter.removeFilterForAddress(this.getServerAddress());
    }
}

