/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.functional.client;

import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.HttpServerConfiguration;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.service.http.impl.functional.AbstractHttpServiceTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public abstract class AbstractHttpClientTestCase
extends AbstractHttpServiceTestCase {
    protected static final int TIMEOUT = 10000;
    @Rule
    public DynamicPort port = new DynamicPort("port");
    protected HttpServer server;

    public AbstractHttpClientTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    @Before
    public void setUp() throws Exception {
        this.server = this.service.getServerFactory().create(this.getServerConfigurationBuilder().build());
        this.server.start();
        this.server.addRequestHandler("/*", (requestContext, responseCallback) -> responseCallback.responseReady(this.setUpHttpResponse(requestContext.getRequest()), (ResponseStatusCallback)new AbstractHttpServiceTestCase.IgnoreResponseStatusCallback()));
    }

    protected HttpServerConfiguration.Builder getServerConfigurationBuilder() throws Exception {
        return new HttpServerConfiguration.Builder().setHost("localhost").setPort(this.port.getNumber()).setName("client-test-server");
    }

    protected abstract HttpResponse setUpHttpResponse(HttpRequest var1);

    protected String getUri() {
        return "http://localhost:" + this.port.getValue();
    }

    @After
    public void tearDown() throws Exception {
        if (this.server != null) {
            this.server.stop();
            this.server.dispose();
        }
    }

    protected HttpRequestOptions getDefaultOptions(int responseTimeout) {
        return HttpRequestOptions.builder().responseTimeout(responseTimeout).build();
    }
}

