/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.functional.client;

import io.qameta.allure.Description;
import io.qameta.allure.Story;
import io.qameta.allure.junit4.DisplayName;
import java.io.IOException;
import org.junit.Test;
import org.mule.runtime.api.util.DataUnit;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.service.http.impl.functional.ResponseReceivedProbe;
import org.mule.service.http.impl.functional.client.AbstractHttpClientTestCase;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Story(value="Streaming")
@DisplayName(value="Validates cases in streaming where POST bodies are consumed more than once")
public abstract class HttpClientPostStreamingTestCase
extends AbstractHttpClientTestCase {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpClientPostStreamingTestCase.class);
    public static final int RESPONSE_TIMEOUT = 3000;
    private static final int TIMEOUT_MILLIS = 1000;
    private static final int POLL_DELAY_MILLIS = 200;
    private String payloadAfterDancing;
    private HttpClientConfiguration.Builder clientBuilder = new HttpClientConfiguration.Builder().setName("streaming-test");
    private PollingProber pollingProber = new PollingProber(1000L, 200L);

    public HttpClientPostStreamingTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Description(value="Verifies that in streaming the redirection preserves the post body and the request stream is not consumed on redirect without reset")
    public void redirectionPreservesPostBody() throws Exception {
        HttpClient client = this.service.getClientFactory().create(this.clientBuilder.setResponseBufferSize(DataUnit.KB.toBytes(10)).setStreaming(true).build());
        client.start();
        Reference responseReference = new Reference();
        try {
            HttpRequestOptions options = this.getOptions();
            HttpRequest request = this.getRequest();
            client.sendAsync(request, options).whenComplete((response, exception) -> {
                HttpResponse cfr_ignored_0 = (HttpResponse)responseReference.set(response);
            });
            this.pollingProber.check((Probe)new ResponseReceivedProbe((Reference<HttpResponse>)responseReference));
            this.pollingProber.check(new Probe(){

                public boolean isSatisfied() {
                    return HttpClientPostStreamingTestCase.this.payloadAfterDancing != null && HttpClientPostStreamingTestCase.this.payloadAfterDancing.equals("test");
                }

                public String describeFailure() {
                    return "Payload in post request was not preserved";
                }
            });
        }
        finally {
            client.stop();
        }
    }

    public abstract HttpRequest getRequest();

    public abstract HttpRequestOptions getOptions();

    @Override
    protected HttpResponse setUpHttpResponse(HttpRequest request) {
        return this.doSetUpHttpResponse(request);
    }

    public abstract HttpResponse doSetUpHttpResponse(HttpRequest var1);

    protected void extractPayload(HttpRequest request) {
        try {
            this.payloadAfterDancing = new String(request.getEntity().getBytes());
        }
        catch (IOException e) {
            LOGGER.debug("Could not extract payload.");
        }
    }
}

