/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.functional.server;

import org.apache.http.HttpVersion;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mule.service.http.impl.functional.server.HttpServerTransferTestCase;

public class HttpServerTransfer11TestCase
extends HttpServerTransferTestCase {
    public HttpServerTransfer11TestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    @Override
    public HttpVersion getVersion() {
        return HttpVersion.HTTP_1_1;
    }

    @Test
    public void defaultsToLengthWhenEmpty() throws Exception {
        this.verifyTransferHeaders("", (Matcher<Object>)Matchers.is((Matcher)Matchers.nullValue()), (Matcher<Object>)Matchers.is((Object)"0"), "");
    }

    @Test
    public void defaultsToLengthWhenBytes() throws Exception {
        this.verifyTransferHeaders("/bytes", (Matcher<Object>)Matchers.is((Matcher)Matchers.nullValue()), (Matcher<Object>)Matchers.is((Object)DATA_SIZE), "My awesome data");
    }

    @Test
    public void defaultsToLengthWhenMultipart() throws Exception {
        this.verifyTransferHeaders("/multipart", (Matcher<Object>)Matchers.is((Matcher)Matchers.nullValue()), (Matcher<Object>)Matchers.is((Object)"112"), "--bounds\r\nContent-Type: text/plain\r\nContent-Disposition: form-data; name=\"name\"\r\n\r\nMy awesome data\r\n--bounds--\r\n");
    }

    @Test
    public void defaultsToChunkedWhenStream() throws Exception {
        this.verifyTransferHeaders("/stream", (Matcher<Object>)Matchers.is((Object)"chunked"), (Matcher<Object>)Matchers.is((Matcher)Matchers.nullValue()), "My awesome data");
    }

    @Test
    public void usesChunkedWhenEmptyAndHeader() throws Exception {
        this.headerToSend = CHUNKED_PAIR;
        this.verifyTransferHeaders("", (Matcher<Object>)Matchers.is((Object)"chunked"), (Matcher<Object>)Matchers.is((Matcher)Matchers.nullValue()), "");
    }

    @Test
    public void usesChunkedWhenBytesAndHeader() throws Exception {
        this.headerToSend = CHUNKED_PAIR;
        this.verifyTransferHeaders("/bytes", (Matcher<Object>)Matchers.is((Object)"chunked"), (Matcher<Object>)Matchers.is((Matcher)Matchers.nullValue()), "My awesome data");
    }

    @Test
    public void usesChunkedWhenMultipartAndHeader() throws Exception {
        this.headerToSend = CHUNKED_PAIR;
        this.verifyTransferHeaders("/multipart", (Matcher<Object>)Matchers.is((Object)"chunked"), (Matcher<Object>)Matchers.is((Matcher)Matchers.nullValue()), "--bounds\r\nContent-Type: text/plain\r\nContent-Disposition: form-data; name=\"name\"\r\n\r\nMy awesome data\r\n--bounds--\r\n");
    }

    @Test
    public void usesChunkedWhenStreamAndHeader() throws Exception {
        this.headerToSend = CHUNKED_PAIR;
        this.verifyTransferHeaders("/stream", (Matcher<Object>)Matchers.is((Object)"chunked"), (Matcher<Object>)Matchers.is((Matcher)Matchers.nullValue()), "My awesome data");
    }
}

