/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.client;

import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.service.http.impl.service.client.GrizzlyHttpClient;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class GrizzlyHttpClientLifecycleTestCase
extends AbstractMuleTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void cannotSendWhenNotStarted() throws Exception {
        HttpClient client = this.validateClientUsage();
        client.send(this.getHttpRequest());
    }

    @Test
    public void cannotSendAsyncWhenNotStarted() {
        HttpClient client = this.validateClientUsage();
        client.sendAsync(this.getHttpRequest());
    }

    private HttpClient validateClientUsage() {
        GrizzlyHttpClient client = new GrizzlyHttpClient((HttpClientConfiguration)Mockito.mock(HttpClientConfiguration.class, (Answer)Mockito.RETURNS_DEEP_STUBS), (SchedulerService)Mockito.mock(SchedulerService.class), (SchedulerConfig)Mockito.mock(SchedulerConfig.class));
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("The client must be started before use.");
        return client;
    }

    private HttpRequest getHttpRequest() {
        return HttpRequest.builder().uri("http://localhost:8081/").build();
    }
}

