/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service;

import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.grizzly.CloseReason;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.client.HttpClientFactory;
import org.mule.runtime.http.api.server.HttpServerFactory;
import org.mule.runtime.http.api.utils.RequestMatcherRegistry;
import org.mule.service.http.impl.service.ServerFactoryCreationException;
import org.mule.service.http.impl.service.client.HttpClientConnectionManager;
import org.mule.service.http.impl.service.server.ContextHttpServerFactory;
import org.mule.service.http.impl.service.server.ContextHttpServerFactoryAdapter;
import org.mule.service.http.impl.service.server.HttpListenerConnectionManager;
import org.mule.service.http.impl.service.util.DefaultRequestMatcherRegistryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServiceImplementation
implements HttpService,
Startable,
Stoppable {
    private static final Logger logger;
    private static final String CONTAINER_CONTEXT = "container";
    protected final SchedulerService schedulerService;
    private final HttpListenerConnectionManager listenerConnectionManager;
    private final HttpClientConnectionManager clientConnectionManager;

    public HttpServiceImplementation(SchedulerService schedulerService) {
        this.schedulerService = schedulerService;
        this.listenerConnectionManager = this.createListenerConnectionManager(schedulerService);
        this.clientConnectionManager = this.createClientConnectionManager();
    }

    public HttpServerFactory getServerFactory() {
        return new ContextHttpServerFactoryAdapter(CONTAINER_CONTEXT, Optional.empty(), this.listenerConnectionManager);
    }

    @Inject
    public HttpServerFactory getServerFactory(Registry registry, MuleContext muleContext) {
        ArtifactType artifactType = muleContext.getArtifactType();
        Optional appName = registry.lookupByName("app.name");
        Optional domainName = registry.lookupByName("domain.name");
        try {
            switch (artifactType) {
                case POLICY: {
                    return this.buildServerFactory(appName, "app.name", ArtifactType.POLICY, Optional.empty(), null, this.listenerConnectionManager);
                }
                case DOMAIN: {
                    return this.buildServerFactory(domainName, "domain.name", ArtifactType.DOMAIN, Optional.empty(), null, this.listenerConnectionManager);
                }
                case APP: {
                    if (domainName.isPresent() && appName.isPresent()) {
                        return this.buildServerFactory(appName, "app.name", ArtifactType.APP, domainName, ArtifactType.DOMAIN, this.listenerConnectionManager);
                    }
                    return this.buildServerFactory(appName, "app.name", ArtifactType.APP, Optional.empty(), null, this.listenerConnectionManager);
                }
            }
        }
        catch (ServerFactoryCreationException e) {
            logger.warn(e.getMessage() + ". Using muleContext Id as context");
        }
        return new ContextHttpServerFactoryAdapter(muleContext.getId(), Optional.empty(), this.listenerConnectionManager);
    }

    private HttpServerFactory buildServerFactory(Optional<String> context, String namePropertyKey, ArtifactType contextType, Optional<String> parentContext, ArtifactType parentType, ContextHttpServerFactory delegate) throws ServerFactoryCreationException {
        return context.map(c -> parentContext.map(pc -> new ContextHttpServerFactoryAdapter(this.buildArtifactServerName((String)c, contextType), Optional.of(this.buildArtifactServerName((String)pc, parentType)), delegate)).orElse(new ContextHttpServerFactoryAdapter(this.buildArtifactServerName((String)c, contextType), Optional.empty(), delegate))).orElseThrow(() -> new ServerFactoryCreationException(I18nMessageFactory.createStaticMessage((String)("Could not create server factory for " + contextType.getAsString() + ", " + namePropertyKey + " not set"))));
    }

    private String buildArtifactServerName(String name, ArtifactType artifactType) {
        return name + "-" + artifactType.getAsString();
    }

    public HttpClientFactory getClientFactory() {
        return config -> this.clientConnectionManager.create(config, SchedulerConfig.config());
    }

    @Inject
    public HttpClientFactory getClientFactory(@Named(value="_muleSchedulerBaseConfig") SchedulerConfig schedulersConfig) {
        return config -> this.clientConnectionManager.create(config, schedulersConfig);
    }

    protected HttpClientConnectionManager createClientConnectionManager() {
        return new HttpClientConnectionManager(this.schedulerService);
    }

    protected HttpListenerConnectionManager createListenerConnectionManager(SchedulerService schedulerService) {
        return new HttpListenerConnectionManager(schedulerService, SchedulerConfig.config());
    }

    public RequestMatcherRegistry.RequestMatcherRegistryBuilder getRequestMatcherRegistryBuilder() {
        return new DefaultRequestMatcherRegistryBuilder();
    }

    public String getName() {
        return "HTTP Service";
    }

    public void start() throws MuleException {
        LifecycleUtils.initialiseIfNeeded((Object)this.listenerConnectionManager);
    }

    public void stop() throws MuleException {
        LifecycleUtils.disposeIfNeeded((Object)this.listenerConnectionManager, (Logger)logger);
    }

    static {
        CloseReason locallyClosedReason = CloseReason.LOCALLY_CLOSED_REASON;
        CloseReason closeReason = CloseReason.REMOTELY_CLOSED_REASON;
        logger = LoggerFactory.getLogger(HttpServiceImplementation.class);
    }
}

