/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.server;

import java.util.HashMap;
import java.util.Map;
import org.mule.runtime.core.api.util.concurrent.FunctionalReadWriteLock;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.PathAndMethodRequestMatcher;
import org.mule.runtime.http.api.server.RequestHandler;
import org.mule.runtime.http.api.server.RequestHandlerManager;
import org.mule.runtime.http.api.server.ServerAddress;
import org.mule.runtime.http.api.utils.RequestMatcherRegistry;
import org.mule.service.http.impl.service.server.BadRequestHandler;
import org.mule.service.http.impl.service.server.DefaultRequestHandlerManager;
import org.mule.service.http.impl.service.server.NoListenerRequestHandler;
import org.mule.service.http.impl.service.server.NoMethodRequestHandler;
import org.mule.service.http.impl.service.server.RequestHandlerProvider;
import org.mule.service.http.impl.service.server.ServerAddressMap;
import org.mule.service.http.impl.service.server.ServiceTemporarilyUnavailableListenerRequestHandler;
import org.mule.service.http.impl.service.util.DefaultRequestMatcherRegistryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpListenerRegistry
implements RequestHandlerProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpListenerRegistry.class);
    private final ServerAddressMap<HttpServer> serverAddressToServerMap = new ServerAddressMap();
    private final Map<HttpServer, RequestMatcherRegistry<RequestHandler>> requestHandlerPerServerAddress = new HashMap<HttpServer, RequestMatcherRegistry<RequestHandler>>();
    private final FunctionalReadWriteLock lock = FunctionalReadWriteLock.readWriteLock();

    public RequestHandlerManager addRequestHandler(HttpServer server, RequestHandler requestHandler, PathAndMethodRequestMatcher requestMatcher) {
        return (RequestHandlerManager)this.lock.withWriteLock(() -> {
            RequestMatcherRegistry serverAddressRequestHandlerRegistry = this.requestHandlerPerServerAddress.get(server);
            if (serverAddressRequestHandlerRegistry == null) {
                serverAddressRequestHandlerRegistry = new DefaultRequestMatcherRegistryBuilder<RequestHandler>().onMethodMismatch(NoMethodRequestHandler::getInstance).onNotFound(NoListenerRequestHandler::getInstance).onInvalidRequest(BadRequestHandler::getInstance).onDisabled(ServiceTemporarilyUnavailableListenerRequestHandler::getInstance).build();
                this.requestHandlerPerServerAddress.put(server, (RequestMatcherRegistry<RequestHandler>)serverAddressRequestHandlerRegistry);
                this.serverAddressToServerMap.put(server.getServerAddress(), server);
            }
            return new DefaultRequestHandlerManager(serverAddressRequestHandlerRegistry.add(requestMatcher, (Object)requestHandler));
        });
    }

    public void removeHandlersFor(HttpServer server) {
        this.lock.withWriteLock(() -> {
            this.requestHandlerPerServerAddress.remove(server);
            this.serverAddressToServerMap.remove(server.getServerAddress());
        });
    }

    @Override
    public boolean hasHandlerFor(ServerAddress serverAddress) {
        return (Boolean)this.lock.withReadLock(r -> this.serverAddressToServerMap.get(serverAddress) != null);
    }

    @Override
    public RequestHandler getRequestHandler(ServerAddress serverAddress, HttpRequest request) {
        LOGGER.debug("Looking RequestHandler for request: {}", (Object)request.getPath());
        return (RequestHandler)this.lock.withReadLock(r -> {
            RequestMatcherRegistry<RequestHandler> serverAddressRequestHandlerRegistry;
            HttpServer server = this.serverAddressToServerMap.get(serverAddress);
            if (server != null && !server.isStopped() && (serverAddressRequestHandlerRegistry = this.requestHandlerPerServerAddress.get(server)) != null) {
                return (RequestHandler)serverAddressRequestHandlerRegistry.find(request);
            }
            LOGGER.debug("No RequestHandler found for request: {}", (Object)request.getPath());
            return NoListenerRequestHandler.getInstance();
        });
    }
}

