/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.client;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.AsyncHttpProvider;
import com.ning.http.client.AsyncHttpProviderConfig;
import com.ning.http.client.BodyDeferringAsyncHandler;
import com.ning.http.client.BodyGenerator;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.ProxyServer;
import com.ning.http.client.Realm;
import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.Response;
import com.ning.http.client.filter.FilterException;
import com.ning.http.client.filter.RequestFilter;
import com.ning.http.client.generators.InputStreamBodyGenerator;
import com.ning.http.client.multipart.ByteArrayPart;
import com.ning.http.client.multipart.Part;
import com.ning.http.client.providers.grizzly.FeedableBodyGenerator;
import com.ning.http.client.providers.grizzly.GrizzlyAsyncHttpProvider;
import com.ning.http.client.providers.grizzly.GrizzlyAsyncHttpProviderConfig;
import com.ning.http.client.providers.grizzly.NonBlockingInputStreamFeeder;
import com.ning.http.client.uri.Uri;
import com.ning.http.util.UTF8UrlEncoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.SSLContext;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.streaming.bytes.CursorStream;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.api.tls.TlsContextTrustStoreConfiguration;
import org.mule.runtime.api.util.DataUnit;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.client.auth.HttpAuthentication;
import org.mule.runtime.http.api.client.auth.HttpAuthenticationType;
import org.mule.runtime.http.api.client.proxy.ProxyConfig;
import org.mule.runtime.http.api.domain.entity.multipart.HttpPart;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.server.HttpServerProperties;
import org.mule.runtime.http.api.tcp.TcpClientSocketProperties;
import org.mule.service.http.impl.service.client.CompositeTransportCustomizer;
import org.mule.service.http.impl.service.client.CursorInputStreamBodyGenerator;
import org.mule.service.http.impl.service.client.CursorNonBlockingInputStreamFeeder;
import org.mule.service.http.impl.service.client.CustomTimeoutThrottleRequestFilter;
import org.mule.service.http.impl.service.client.HttpResponseCreator;
import org.mule.service.http.impl.service.client.IOStrategyTransportCustomizer;
import org.mule.service.http.impl.service.client.LoggerTransportCustomizer;
import org.mule.service.http.impl.service.client.SocketConfigTransportCustomizer;
import org.mule.service.http.impl.service.client.async.PreservingClassLoaderAsyncHandler;
import org.mule.service.http.impl.service.client.async.ResponseAsyncHandler;
import org.mule.service.http.impl.service.client.async.ResponseBodyDeferringAsyncHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrizzlyHttpClient
implements HttpClient {
    private static final int DEFAULT_SELECTOR_THREAD_COUNT = Integer.getInteger(GrizzlyHttpClient.class.getName() + ".DEFAULT_SELECTOR_THREAD_COUNT", Integer.max(Runtime.getRuntime().availableProcessors(), 2));
    private static final int MAX_CONNECTION_LIFETIME = 1800000;
    public static final String HOST_SEPARATOR = ",";
    private static final int DEFAULT_SEND_AND_DEFER_BUFFER_SIZE = DataUnit.KB.toBytes(10);
    private static final String DEFAULT_DECOMPRESS_PROPERTY_NAME = "mule.http.client.decompress";
    private static final String ENABLE_REQUEST_STREAMING_PROPERTY_NAME = "mule.http.requestStreaming.enable";
    private static boolean requestStreamingEnabled = System.getProperties().containsKey("mule.http.requestStreaming.enable");
    private static final int DEFAULT_REQUEST_STREAMING_BUFFER_SIZE = 8192;
    private static final String REQUEST_STREAMING_BUFFER_LEN_PROPERTY_NAME = "mule.http.requestStreaming.bufferSize";
    private static int requestStreamingBufferSize = Integer.getInteger("mule.http.requestStreaming.bufferSize", 8192);
    public static final String CUSTOM_MAX_HTTP_PACKET_HEADER_SIZE = "mule.http.client.headerSectionSize";
    private static final Logger logger = LoggerFactory.getLogger(GrizzlyHttpClient.class);
    private static final String HEADER_CONNECTION = "Connection".toLowerCase();
    private static final String HEADER_CONTENT_LENGTH = "Content-Length".toLowerCase();
    private static final String HEADER_TRANSFER_ENCODING = "Transfer-Encoding".toLowerCase();
    private static boolean DEFAULT_DECOMPRESS = Boolean.getBoolean("mule.http.client.decompress");
    private final TlsContextFactory tlsContextFactory;
    private final ProxyConfig proxyConfig;
    private final TcpClientSocketProperties clientSocketProperties;
    private final int maxConnections;
    private final boolean usePersistentConnections;
    private final int connectionIdleTimeout;
    private final boolean streamingEnabled;
    private final int responseBufferSize;
    private final String name;
    private final boolean decompressionEnabled;
    private Scheduler selectorScheduler;
    private Scheduler workerScheduler;
    private final SchedulerService schedulerService;
    private final SchedulerConfig schedulersConfig;
    protected AsyncHttpClient asyncHttpClient;
    private SSLContext sslContext;
    private final HttpResponseCreator httpResponseCreator = new HttpResponseCreator();
    private final TlsContextFactory defaultTlsContextFactory = TlsContextFactory.builder().buildDefault();

    public GrizzlyHttpClient(HttpClientConfiguration config, SchedulerService schedulerService, SchedulerConfig schedulersConfig) {
        this.tlsContextFactory = config.getTlsContextFactory();
        this.proxyConfig = config.getProxyConfig();
        this.clientSocketProperties = config.getClientSocketProperties();
        this.maxConnections = config.getMaxConnections();
        this.usePersistentConnections = config.isUsePersistentConnections();
        this.connectionIdleTimeout = config.getConnectionIdleTimeout();
        this.streamingEnabled = config.isStreaming();
        this.responseBufferSize = config.getResponseBufferSize();
        this.decompressionEnabled = config.isDecompress() != null ? config.isDecompress() : DEFAULT_DECOMPRESS;
        this.name = config.getName();
        this.schedulerService = schedulerService;
        this.schedulersConfig = schedulersConfig;
    }

    public void start() {
        this.selectorScheduler = this.schedulerService.customScheduler(this.schedulersConfig.withDirectRunCpuLightWhenTargetBusy(true).withMaxConcurrentTasks(DEFAULT_SELECTOR_THREAD_COUNT).withName(this.name), 0);
        this.workerScheduler = this.schedulerService.ioScheduler(this.schedulersConfig);
        AsyncHttpClientConfig.Builder builder = new AsyncHttpClientConfig.Builder();
        builder.setAllowPoolingConnections(true);
        this.configureTransport(builder);
        this.configureTlsContext(builder);
        this.configureProxy(builder);
        this.configureConnections(builder);
        AsyncHttpClientConfig config = builder.build();
        this.asyncHttpClient = new AsyncHttpClient((AsyncHttpProvider)new GrizzlyAsyncHttpProvider(config), config);
    }

    private void configureTlsContext(AsyncHttpClientConfig.Builder builder) {
        TlsContextFactory resolvedTlsContextFactory;
        if (this.tlsContextFactory != null) {
            resolvedTlsContextFactory = this.tlsContextFactory;
            try {
                this.sslContext = this.tlsContextFactory.createSslContext();
            }
            catch (Exception e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Cannot initialize SSL context"), (Throwable)e);
            }
            builder.setSSLContext(this.sslContext);
            TlsContextTrustStoreConfiguration trustStoreConfiguration = this.tlsContextFactory.getTrustStoreConfiguration();
            if (trustStoreConfiguration != null && trustStoreConfiguration.isInsecure()) {
                logger.warn(String.format("TLS configuration for client %s has been set to use an insecure trust store. This means no certificate validations will be performed, rendering connections vulnerable to attacks. Use at own risk.", this.name));
                builder.setAcceptAnyCertificate(true);
            }
        } else {
            resolvedTlsContextFactory = this.defaultTlsContextFactory;
        }
        if (resolvedTlsContextFactory.getEnabledCipherSuites() != null) {
            builder.setEnabledCipherSuites(resolvedTlsContextFactory.getEnabledCipherSuites());
        }
        if (resolvedTlsContextFactory.getEnabledProtocols() != null) {
            builder.setEnabledProtocols(resolvedTlsContextFactory.getEnabledProtocols());
        }
    }

    private void configureProxy(AsyncHttpClientConfig.Builder builder) {
        if (this.proxyConfig != null) {
            this.doConfigureProxy(builder, this.proxyConfig);
        }
    }

    protected void doConfigureProxy(AsyncHttpClientConfig.Builder builder, ProxyConfig proxyConfig) {
        builder.setProxyServer(this.buildProxy(proxyConfig));
    }

    protected final ProxyServer buildProxy(ProxyConfig proxyConfig) {
        ProxyServer proxyServer;
        if (!StringUtils.isEmpty((String)proxyConfig.getUsername())) {
            proxyServer = new ProxyServer(proxyConfig.getHost(), proxyConfig.getPort(), proxyConfig.getUsername(), proxyConfig.getPassword());
            if (proxyConfig instanceof ProxyConfig.NtlmProxyConfig) {
                proxyServer.setNtlmDomain(((ProxyConfig.NtlmProxyConfig)proxyConfig).getNtlmDomain());
                try {
                    proxyServer.setNtlmHost(this.getHostName());
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
                proxyServer.setScheme(Realm.AuthScheme.NTLM);
            }
        } else {
            proxyServer = new ProxyServer(proxyConfig.getHost(), proxyConfig.getPort());
        }
        if (proxyConfig.getNonProxyHosts() != null && !proxyConfig.getNonProxyHosts().isEmpty()) {
            for (String host : proxyConfig.getNonProxyHosts().split(HOST_SEPARATOR)) {
                proxyServer.addNonProxyHost(host.trim());
            }
        }
        return proxyServer;
    }

    private void configureTransport(AsyncHttpClientConfig.Builder builder) {
        GrizzlyAsyncHttpProviderConfig providerConfig = new GrizzlyAsyncHttpProviderConfig();
        CompositeTransportCustomizer compositeTransportCustomizer = new CompositeTransportCustomizer();
        compositeTransportCustomizer.addTransportCustomizer(new IOStrategyTransportCustomizer((ExecutorService)this.selectorScheduler, (ExecutorService)this.workerScheduler, this.streamingEnabled, DEFAULT_SELECTOR_THREAD_COUNT));
        compositeTransportCustomizer.addTransportCustomizer(new LoggerTransportCustomizer(this.name));
        if (this.clientSocketProperties != null) {
            compositeTransportCustomizer.addTransportCustomizer(new SocketConfigTransportCustomizer(this.clientSocketProperties));
            builder.setConnectTimeout(this.clientSocketProperties.getConnectionTimeout().intValue());
        }
        providerConfig.addProperty(GrizzlyAsyncHttpProviderConfig.Property.TRANSPORT_CUSTOMIZER, (Object)compositeTransportCustomizer);
        providerConfig.addProperty(GrizzlyAsyncHttpProviderConfig.Property.DECOMPRESS_RESPONSE, (Object)this.decompressionEnabled);
        providerConfig.addProperty(GrizzlyAsyncHttpProviderConfig.Property.MAX_HTTP_PACKET_HEADER_SIZE, (Object)this.retrieveMaximumHeaderSectionSize());
        builder.setAsyncHttpClientProviderConfig((AsyncHttpProviderConfig)providerConfig);
    }

    private void configureConnections(AsyncHttpClientConfig.Builder builder) {
        if (this.maxConnections > 0) {
            builder.addRequestFilter((RequestFilter)new CustomTimeoutThrottleRequestFilter(this.maxConnections));
        }
        builder.setMaxConnections(this.maxConnections);
        builder.setMaxConnectionsPerHost(this.maxConnections);
        builder.setAllowPoolingConnections(this.usePersistentConnections);
        builder.setAllowPoolingSslConnections(this.usePersistentConnections);
        builder.setConnectionTTL(1800000);
        builder.setPooledConnectionIdleTimeout(this.connectionIdleTimeout);
        builder.setIOThreadMultiplier(1);
    }

    public HttpResponse send(HttpRequest request, HttpRequestOptions options) throws IOException, TimeoutException {
        Preconditions.checkState((this.asyncHttpClient != null ? 1 : 0) != 0, (String)"The client must be started before use.");
        if (this.streamingEnabled) {
            return this.sendAndDefer(request, options);
        }
        return this.sendAndWait(request, options);
    }

    private HttpResponse sendAndDefer(HttpRequest request, HttpRequestOptions options) throws IOException, TimeoutException {
        Request grizzlyRequest = this.createGrizzlyRequest(request, options);
        PipedOutputStream outPipe = new PipedOutputStream();
        PipedInputStream inPipe = new PipedInputStream(outPipe, this.responseBufferSize > 0 ? this.responseBufferSize : DEFAULT_SEND_AND_DEFER_BUFFER_SIZE);
        BodyDeferringAsyncHandler asyncHandler = new BodyDeferringAsyncHandler((OutputStream)outPipe);
        this.asyncHttpClient.executeRequest(grizzlyRequest, (AsyncHandler)asyncHandler);
        try {
            Response response = asyncHandler.getResponse();
            return this.httpResponseCreator.create(response, inPipe);
        }
        catch (IOException e) {
            if (e.getCause() instanceof TimeoutException) {
                throw (TimeoutException)e.getCause();
            }
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException(e);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    private HttpResponse sendAndWait(HttpRequest request, HttpRequestOptions options) throws IOException, TimeoutException {
        Request grizzlyRequest = this.createGrizzlyRequest(request, options);
        ListenableFuture future = this.asyncHttpClient.executeRequest(grizzlyRequest);
        try {
            Response response = (Response)future.get();
            if (response == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Null response returned by async client");
                }
                response = (Response)future.get();
            }
            return this.httpResponseCreator.create(response, response.getResponseBodyAsStream());
        }
        catch (InterruptedException e) {
            throw new IOException(e.getMessage(), e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof TimeoutException) {
                throw (TimeoutException)e.getCause();
            }
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            if (e.getCause() instanceof FilterException) {
                throw new IOException(e.getCause().getMessage(), e.getCause());
            }
            throw new IOException(e.getMessage(), e);
        }
    }

    public CompletableFuture<HttpResponse> sendAsync(HttpRequest request, HttpRequestOptions options) {
        Preconditions.checkState((this.asyncHttpClient != null ? 1 : 0) != 0, (String)"The client must be started before use.");
        CompletableFuture<HttpResponse> future = new CompletableFuture<HttpResponse>();
        try {
            PreservingClassLoaderAsyncHandler<Object> asyncHandler = this.streamingEnabled ? new PreservingClassLoaderAsyncHandler<Response>(new ResponseBodyDeferringAsyncHandler(future, this.responseBufferSize)) : new PreservingClassLoaderAsyncHandler(new ResponseAsyncHandler(future));
            this.asyncHttpClient.executeRequest(this.createGrizzlyRequest(request, options), asyncHandler);
        }
        catch (Exception e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    protected Request createGrizzlyRequest(HttpRequest request, HttpRequestOptions options) throws IOException {
        RequestBuilder reqBuilder = this.createRequestBuilder(request, options, builder -> {
            builder.setFollowRedirects(options.isFollowsRedirect());
            this.populateHeaders(request, builder);
            for (Map.Entry entry : request.getQueryParams().entryList()) {
                builder.addQueryParam(entry.getKey() != null ? UTF8UrlEncoder.encodeQueryElement((String)((String)entry.getKey())) : null, entry.getValue() != null ? UTF8UrlEncoder.encodeQueryElement((String)((String)entry.getValue())) : null);
            }
            options.getAuthentication().ifPresent(authentication -> {
                Realm.RealmBuilder realmBuilder = new Realm.RealmBuilder().setPrincipal(authentication.getUsername()).setPassword(authentication.getPassword()).setUsePreemptiveAuth(authentication.isPreemptive());
                if (authentication.getType() == HttpAuthenticationType.BASIC) {
                    realmBuilder.setScheme(Realm.AuthScheme.BASIC);
                } else if (authentication.getType() == HttpAuthenticationType.DIGEST) {
                    realmBuilder.setScheme(Realm.AuthScheme.DIGEST);
                } else if (authentication.getType() == HttpAuthenticationType.NTLM) {
                    String workstation;
                    String domain = ((HttpAuthentication.HttpNtlmAuthentication)authentication).getDomain();
                    if (domain != null) {
                        realmBuilder.setNtlmDomain(domain);
                    }
                    String ntlmHost = (workstation = ((HttpAuthentication.HttpNtlmAuthentication)authentication).getWorkstation()) != null ? workstation : this.getHostName();
                    realmBuilder.setNtlmHost(ntlmHost).setScheme(Realm.AuthScheme.NTLM);
                }
                builder.setRealm(realmBuilder.build());
            });
            options.getProxyConfig().ifPresent(proxyConfig -> builder.setProxyServer(this.buildProxy((ProxyConfig)proxyConfig)));
            if (request.getEntity() != null) {
                if (request.getEntity().isStreaming()) {
                    this.setStreamingBodyToRequestBuilder(request, builder);
                } else if (request.getEntity().isComposed()) {
                    for (HttpPart part : request.getEntity().getParts()) {
                        if (part.getFileName() != null) {
                            builder.addBodyPart((Part)new ByteArrayPart(part.getName(), IOUtils.toByteArray((InputStream)part.getInputStream()), part.getContentType(), null, part.getFileName()));
                            continue;
                        }
                        byte[] content = IOUtils.toByteArray((InputStream)part.getInputStream());
                        builder.addBodyPart((Part)new ByteArrayPart(part.getName(), content, part.getContentType(), null));
                    }
                } else {
                    builder.setBody(request.getEntity().getBytes());
                }
            }
            builder.setRequestTimeout(options.getResponseTimeout());
        });
        URI uri = request.getUri();
        reqBuilder.setUri(new Uri(uri.getScheme(), uri.getRawUserInfo(), uri.getHost(), uri.getPort(), uri.getRawPath(), uri.getRawQuery() != null ? uri.getRawQuery() + (request.getQueryParams().isEmpty() ? "" : "&") : null));
        return reqBuilder.build();
    }

    private void setStreamingBodyToRequestBuilder(HttpRequest request, RequestBuilder builder) throws IOException {
        if (GrizzlyHttpClient.isRequestStreamingEnabled()) {
            FeedableBodyGenerator bodyGenerator = new FeedableBodyGenerator();
            bodyGenerator.setFeeder((FeedableBodyGenerator.Feeder)new InputStreamFeederFactory(bodyGenerator, request.getEntity().getContent(), requestStreamingBufferSize).getInputStreamFeeder());
            builder.setBody((BodyGenerator)bodyGenerator);
        } else {
            builder.setBody((BodyGenerator)new InputStreamBodyGeneratorFactory(request.getEntity().getContent()).getInputStreamBodyGenerator());
        }
    }

    protected RequestBuilder createRequestBuilder(HttpRequest request, HttpRequestOptions options, RequestConfigurer requestConfigurer) throws IOException {
        RequestBuilder requestBuilder = new RequestBuilder(request.getMethod(), true);
        requestConfigurer.configure(requestBuilder);
        return requestBuilder;
    }

    protected void populateHeaders(HttpRequest request, RequestBuilder builder) {
        boolean hasTransferEncoding = false;
        boolean hasContentLength = false;
        boolean hasConnection = false;
        for (String headerName : request.getHeaderNames()) {
            boolean specialHeader = false;
            if (!hasTransferEncoding && headerName.equalsIgnoreCase(HEADER_TRANSFER_ENCODING)) {
                hasTransferEncoding = true;
                specialHeader = true;
                builder.addHeader(HttpServerProperties.PRESERVE_HEADER_CASE ? "Transfer-Encoding" : HEADER_TRANSFER_ENCODING, request.getHeaderValue(headerName));
            }
            if (!hasContentLength && headerName.equalsIgnoreCase(HEADER_CONTENT_LENGTH)) {
                hasContentLength = true;
                specialHeader = true;
                builder.addHeader(HttpServerProperties.PRESERVE_HEADER_CASE ? "Content-Length" : HEADER_CONTENT_LENGTH, request.getHeaderValue(headerName));
            }
            if (!hasContentLength && headerName.equalsIgnoreCase(HEADER_CONNECTION)) {
                hasConnection = true;
                specialHeader = true;
                builder.addHeader(HttpServerProperties.PRESERVE_HEADER_CASE ? "Connection" : HEADER_CONNECTION, request.getHeaderValue(headerName));
            }
            if (specialHeader) continue;
            for (String headerValue : request.getHeaderValues(headerName)) {
                builder.addHeader(headerName, headerValue);
            }
        }
        if (!hasTransferEncoding && !hasContentLength && request.getEntity().getBytesLength().isPresent()) {
            builder.addHeader(HttpServerProperties.PRESERVE_HEADER_CASE ? "Content-Length" : HEADER_CONTENT_LENGTH, String.valueOf(request.getEntity().getBytesLength().getAsLong()));
        }
        if (!this.usePersistentConnections) {
            if (hasConnection && logger.isDebugEnabled() && !"close".equals(request.getHeaderValue(HEADER_CONNECTION))) {
                logger.debug("Persistent connections are disabled in the HTTP requester configuration, but the request already contains a Connection header with value {}. This header will be ignored, and a Connection: close header will be sent instead.", (Object)request.getHeaderValue(HEADER_CONNECTION));
            }
            builder.setHeader(HttpServerProperties.PRESERVE_HEADER_CASE ? "Connection" : HEADER_CONNECTION, "close");
        }
    }

    private String getHostName() throws UnknownHostException {
        return InetAddress.getLocalHost().getHostName();
    }

    protected ProxyConfig getProxyConfig() {
        return this.proxyConfig;
    }

    public void stop() {
        this.asyncHttpClient.close();
        this.workerScheduler.stop();
        this.selectorScheduler.stop();
    }

    public static void refreshSystemProperties() {
        DEFAULT_DECOMPRESS = Boolean.getBoolean(DEFAULT_DECOMPRESS_PROPERTY_NAME);
    }

    private static boolean isRequestStreamingEnabled() {
        return requestStreamingEnabled;
    }

    private int retrieveMaximumHeaderSectionSize() {
        try {
            return Integer.valueOf(System.getProperty(CUSTOM_MAX_HTTP_PACKET_HEADER_SIZE, String.valueOf(8192)));
        }
        catch (NumberFormatException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Invalid value '%s' for '%s' configuration.", System.getProperty(CUSTOM_MAX_HTTP_PACKET_HEADER_SIZE), CUSTOM_MAX_HTTP_PACKET_HEADER_SIZE)), (Throwable)e);
        }
    }

    private static class InputStreamBodyGeneratorFactory {
        private InputStream inputStream;

        public InputStreamBodyGeneratorFactory(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        public InputStreamBodyGenerator getInputStreamBodyGenerator() {
            if (this.inputStream instanceof CursorStream) {
                return new CursorInputStreamBodyGenerator((CursorStream)this.inputStream);
            }
            return new InputStreamBodyGenerator(this.inputStream);
        }
    }

    private static class InputStreamFeederFactory {
        private FeedableBodyGenerator feedableBodyGenerator;
        private InputStream content;
        private int internalBufferSize;

        public InputStreamFeederFactory(FeedableBodyGenerator feedableBodyGenerator, InputStream content, int internalBufferSize) {
            this.feedableBodyGenerator = feedableBodyGenerator;
            this.content = content;
            this.internalBufferSize = internalBufferSize;
        }

        public NonBlockingInputStreamFeeder getInputStreamFeeder() {
            if (this.content instanceof CursorStream) {
                return new CursorNonBlockingInputStreamFeeder(this.feedableBodyGenerator, (CursorStream)this.content, this.internalBufferSize);
            }
            return new NonBlockingInputStreamFeeder(this.feedableBodyGenerator, this.content, this.internalBufferSize);
        }
    }

    @FunctionalInterface
    protected static interface RequestConfigurer {
        public void configure(RequestBuilder var1) throws IOException;
    }
}

