/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.config;

import io.qameta.allure.Feature;
import java.io.File;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.service.http.impl.config.ContainerTcpServerSocketProperties;
import org.mule.tck.junit4.AbstractMuleTestCase;

@Feature(value="HTTP Service")
public class ContainerTcpServerSocketPropertiesTestCase
extends AbstractMuleTestCase {
    @Test
    public void usesDefaultProperties() throws MuleException {
        ContainerTcpServerSocketProperties properties = ContainerTcpServerSocketProperties.loadTcpServerSocketProperties();
        Assert.assertThat((Object)properties.getSendBufferSize(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)properties.getReceiveBufferSize(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)properties.getClientTimeout(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)properties.getSendTcpNoDelay(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)properties.getLinger(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)properties.getKeepAlive(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)properties.getReuseAddress(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)properties.getReceiveBacklog(), (Matcher)Matchers.is((Object)50));
        Assert.assertThat((Object)properties.getServerTimeout(), (Matcher)Matchers.is((Object)60000));
    }

    @Test
    public void loadsPropertiesFromMuleHome() throws MuleException {
        String muleHome = System.getProperty("mule.home");
        try {
            System.setProperty("mule.home", ClassUtils.getClassPathRoot(ContainerTcpServerSocketPropertiesTestCase.class).getPath());
            ContainerTcpServerSocketProperties properties = ContainerTcpServerSocketProperties.loadTcpServerSocketProperties();
            Assert.assertThat((Object)properties.getSendBufferSize(), (Matcher)Matchers.is((Object)1024));
            Assert.assertThat((Object)properties.getReceiveBufferSize(), (Matcher)Matchers.is((Object)2048));
            Assert.assertThat((Object)properties.getClientTimeout(), (Matcher)Matchers.is((Object)60000));
            Assert.assertThat((Object)properties.getSendTcpNoDelay(), (Matcher)Matchers.is((Object)false));
            Assert.assertThat((Object)properties.getLinger(), (Matcher)Matchers.is((Object)30000));
            Assert.assertThat((Object)properties.getKeepAlive(), (Matcher)Matchers.is((Object)true));
            Assert.assertThat((Object)properties.getReuseAddress(), (Matcher)Matchers.is((Object)false));
            Assert.assertThat((Object)properties.getReceiveBacklog(), (Matcher)Matchers.is((Object)42));
            Assert.assertThat((Object)properties.getServerTimeout(), (Matcher)Matchers.is((Object)20000));
        }
        finally {
            this.restore("mule.home", muleHome);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void loadsPropertiesFromOverrideFile() throws MuleException {
        String muleHome = System.getProperty("mule.home");
        String overrideFile = System.getProperty("mule.httpServerSockets.confFile");
        try {
            String testResourcePath = ClassUtils.getClassPathRoot(ContainerTcpServerSocketPropertiesTestCase.class).getPath();
            System.setProperty("mule.home", testResourcePath);
            System.setProperty("mule.httpServerSockets.confFile", testResourcePath + File.separator + "http-server-sockets-override.conf");
            ContainerTcpServerSocketProperties properties = ContainerTcpServerSocketProperties.loadTcpServerSocketProperties();
            Assert.assertThat((Object)properties.getSendBufferSize(), (Matcher)Matchers.is((Object)2048));
            Assert.assertThat((Object)properties.getReceiveBufferSize(), (Matcher)Matchers.is((Object)1024));
            Assert.assertThat((Object)properties.getClientTimeout(), (Matcher)Matchers.is((Object)30000));
            Assert.assertThat((Object)properties.getSendTcpNoDelay(), (Matcher)Matchers.is((Object)true));
            Assert.assertThat((Object)properties.getLinger(), (Matcher)Matchers.is((Object)60000));
            Assert.assertThat((Object)properties.getKeepAlive(), (Matcher)Matchers.is((Object)false));
            Assert.assertThat((Object)properties.getReuseAddress(), (Matcher)Matchers.is((Object)true));
            Assert.assertThat((Object)properties.getReceiveBacklog(), (Matcher)Matchers.is((Object)96));
            Assert.assertThat((Object)properties.getServerTimeout(), (Matcher)Matchers.is((Object)30000));
        }
        finally {
            this.restore("mule.home", muleHome);
            this.restore("mule.httpServerSockets.confFile", overrideFile);
        }
    }

    private void restore(String property, String value) {
        if (value != null) {
            System.setProperty(property, value);
        } else {
            System.clearProperty(property);
        }
    }
}

