/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.server.grizzly;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.ServerAddress;
import org.mule.runtime.http.api.server.ServerCreationException;
import org.mule.runtime.http.api.tcp.TcpServerSocketProperties;
import org.mule.service.http.impl.service.server.DefaultServerAddress;
import org.mule.service.http.impl.service.server.HttpListenerRegistry;
import org.mule.service.http.impl.service.server.ServerIdentifier;
import org.mule.service.http.impl.service.server.grizzly.AbstractGrizzlyServerManagerTestCase;
import org.mule.service.http.impl.service.server.grizzly.GrizzlyServerManager;
import org.mule.service.http.impl.service.server.grizzly.WorkManagerSourceExecutorProvider;

@Feature(value="HTTP Service")
@Story(value="Server Management")
public class HttpGrizzlyServerManagerTestCase
extends AbstractGrizzlyServerManagerTestCase {
    private final TlsContextFactory tlsContextFactory = TlsContextFactory.builder().buildDefault();

    @Override
    protected HttpServer getServer(ServerAddress address, ServerIdentifier id) throws ServerCreationException {
        return this.serverManager.createServerFor(address, () -> muleContext.getSchedulerService().ioScheduler(), true, (int)TimeUnit.SECONDS.toMillis(60L), id, () -> muleContext.getConfiguration().getShutdownTimeout());
    }

    @Test
    public void serverIsHttp() throws Exception {
        HttpServer createdServer = this.getServer((ServerAddress)new DefaultServerAddress(HttpConstants.ALL_INTERFACES_ADDRESS, this.listenerPort.getNumber()), new ServerIdentifier("context", "name"));
        try {
            Assert.assertThat((Object)createdServer.getProtocol(), (Matcher)Matchers.is((Object)HttpConstants.Protocol.HTTP));
        }
        finally {
            createdServer.dispose();
        }
    }

    @Test
    public void enableTls() throws Exception {
        HttpServer createdServer = this.getServer((ServerAddress)new DefaultServerAddress(HttpConstants.ALL_INTERFACES_ADDRESS, this.listenerPort.getNumber()), new ServerIdentifier("context", "name"));
        try {
            Assert.assertThat((Object)createdServer.getProtocol(), (Matcher)Matchers.is((Object)HttpConstants.Protocol.HTTP));
            createdServer.enableTls(this.tlsContextFactory);
            Assert.assertThat((Object)createdServer.getProtocol(), (Matcher)Matchers.is((Object)HttpConstants.Protocol.HTTPS));
        }
        finally {
            createdServer.dispose();
        }
    }

    @Test
    public void symmetricUsageOfWorkManagerSourceExecutorProviderOnStartAndStop() throws ServerCreationException, IOException {
        HttpServer createdServer = this.getServer((ServerAddress)new DefaultServerAddress(HttpConstants.ALL_INTERFACES_ADDRESS, this.listenerPort.getNumber()), new ServerIdentifier("context", "name"));
        int adds = 0;
        int removes = 0;
        this.assertProviderUsage(adds, removes);
        for (int i = 0; i < 3; ++i) {
            createdServer.start();
            this.assertProviderUsage(++adds, removes);
            createdServer.stop();
            this.assertProviderUsage(adds, ++removes);
        }
        createdServer.dispose();
        this.assertProviderUsage(adds, removes);
    }

    private void assertProviderUsage(int adds, int removes) {
        ((WorkManagerSourceExecutorProvider)Mockito.verify((Object)((HttpGrizzlyServerManagerTestDecorator)this.serverManager).getSpiedExecutorProvider(), (VerificationMode)Mockito.times((int)adds))).addExecutor((ServerAddress)ArgumentMatchers.any(), (Supplier)ArgumentMatchers.any());
        ((WorkManagerSourceExecutorProvider)Mockito.verify((Object)((HttpGrizzlyServerManagerTestDecorator)this.serverManager).getSpiedExecutorProvider(), (VerificationMode)Mockito.times((int)removes))).removeExecutor((ServerAddress)ArgumentMatchers.any());
    }

    @Override
    protected HttpGrizzlyServerManagerTestDecorator createServerManager(HttpListenerRegistry registry, AbstractGrizzlyServerManagerTestCase.DefaultTcpServerSocketProperties socketProperties) {
        return new HttpGrizzlyServerManagerTestDecorator(this.selectorPool, this.workerPool, this.idleTimeoutExecutorService, registry, socketProperties, Runtime.getRuntime().availableProcessors());
    }

    private static class HttpGrizzlyServerManagerTestDecorator
    extends GrizzlyServerManager {
        WorkManagerSourceExecutorProvider spiedExecutorProvider;

        HttpGrizzlyServerManagerTestDecorator(ExecutorService selectorPool, ExecutorService workerPool, ExecutorService idleTimeoutExecutorService, HttpListenerRegistry httpListenerRegistry, TcpServerSocketProperties serverSocketProperties, int selectorCount) {
            super(selectorPool, workerPool, idleTimeoutExecutorService, httpListenerRegistry, serverSocketProperties, selectorCount);
        }

        protected WorkManagerSourceExecutorProvider createExecutorProvider() {
            this.spiedExecutorProvider = (WorkManagerSourceExecutorProvider)Mockito.spy((Object)new WorkManagerSourceExecutorProvider());
            return this.spiedExecutorProvider;
        }

        WorkManagerSourceExecutorProvider getSpiedExecutorProvider() {
            return this.spiedExecutorProvider;
        }
    }
}

