/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.server.grizzly;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.io.InputStream;
import org.glassfish.grizzly.Transport;
import org.glassfish.grizzly.http.ProcessingState;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.InputStreamHttpEntity;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.service.http.impl.service.server.grizzly.BaseResponseCompletionHandler;
import org.mule.service.http.impl.service.server.grizzly.BaseResponseCompletionHandlerTestCase;
import org.mule.service.http.impl.service.server.grizzly.ResponseStreamingCompletionHandler;

@Feature(value="HTTP Service")
@Story(value="Responses")
public class ResponseStreamingCompletionHandlerTestCase
extends BaseResponseCompletionHandlerTestCase {
    private ResponseStreamingCompletionHandler handler;
    private InputStream mockStream;

    @Before
    public void setUp() {
        Mockito.when((Object)this.ctx.getConnection()).thenReturn((Object)this.connection);
        Mockito.when((Object)this.connection.getTransport()).thenReturn(Mockito.mock(Transport.class, (Answer)Mockito.RETURNS_DEEP_STUBS));
        this.mockStream = (InputStream)Mockito.mock(InputStream.class);
        this.responseMock = ((HttpResponseBuilder)HttpResponse.builder().entity((HttpEntity)new InputStreamHttpEntity(this.mockStream))).build();
        this.handler = new ResponseStreamingCompletionHandler(this.ctx, Thread.currentThread().getContextClassLoader(), this.request, this.responseMock, this.callback);
    }

    @Override
    protected BaseResponseCompletionHandler getHandler() {
        return this.handler;
    }

    @Test
    public void keepAliveConnection() {
        MultiMap headers = new MultiMap();
        headers.put((Object)"Connection", (Object)"Keep-Alive");
        this.responseMock = ((HttpResponseBuilder)((HttpResponseBuilder)HttpResponse.builder().entity((HttpEntity)new InputStreamHttpEntity(this.mockStream))).headers(headers)).build();
        this.handler = new ResponseStreamingCompletionHandler(this.ctx, Thread.currentThread().getContextClassLoader(), this.request, this.responseMock, this.callback);
        MatcherAssert.assertThat((Object)this.handler.getHttpResponsePacket().getHeader("Connection"), (Matcher)Matchers.equalTo((Object)"Keep-Alive"));
    }

    @Test
    public void cLoseConnection() {
        MultiMap headers = new MultiMap();
        headers.put((Object)"Connection", (Object)"close");
        this.responseMock = ((HttpResponseBuilder)((HttpResponseBuilder)HttpResponse.builder().entity((HttpEntity)new InputStreamHttpEntity(this.mockStream))).headers(headers)).build();
        Mockito.when((Object)this.request.getProcessingState()).thenReturn((Object)new ProcessingState());
        this.handler = new ResponseStreamingCompletionHandler(this.ctx, Thread.currentThread().getContextClassLoader(), this.request, this.responseMock, this.callback);
        MatcherAssert.assertThat((Object)this.getHandler().getHttpResponsePacket().getHeader("Connection"), (Matcher)Matchers.equalTo((Object)"close"));
    }
}

