/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.server;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.server.ServerAddress;
import org.mule.service.http.impl.service.server.DefaultServerAddress;

public class ServerAddressMap<T> {
    private Map<ServerAddress, T> internalMap;
    private boolean specificAddressPresent;

    public ServerAddressMap() {
        this(new HashMap());
    }

    public ServerAddressMap(Map<ServerAddress, T> internalMap) {
        this.internalMap = internalMap;
        this.checkForSpecificAddresses();
    }

    private void checkForSpecificAddresses() {
        this.specificAddressPresent = this.internalMap.keySet().stream().anyMatch(sa -> !HttpConstants.ALL_INTERFACES_ADDRESS.equals(sa.getAddress()));
    }

    public void put(ServerAddress serverAddress, T value) {
        this.internalMap.put(serverAddress, value);
        this.checkForSpecificAddresses();
    }

    public T get(Object key) {
        if (this.specificAddressPresent) {
            T value = this.internalMap.get(key);
            if (value == null) {
                value = this.internalMap.get(new DefaultServerAddress(HttpConstants.ALL_INTERFACES_ADDRESS, ((ServerAddress)key).getPort()));
            }
            return value;
        }
        return this.internalMap.get(new DefaultServerAddress(HttpConstants.ALL_INTERFACES_ADDRESS, ((ServerAddress)key).getPort()));
    }

    public T get(InetAddress address, int port) {
        return this.get(new DefaultServerAddress(address, port));
    }

    public boolean containsKey(Object key) {
        return this.internalMap.containsKey(key);
    }

    public T remove(Object key) {
        T removed = this.internalMap.remove(key);
        this.checkForSpecificAddresses();
        return removed;
    }
}

