/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.server.grizzly;

import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Collection;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.Protocol;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.http.api.domain.CaseInsensitiveMultiMap;
import org.mule.runtime.http.api.domain.HttpProtocol;
import org.mule.runtime.http.api.domain.message.BaseHttpMessage;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.server.HttpServerProperties;
import org.mule.runtime.http.api.utils.HttpEncoderDecoderUtils;
import org.mule.runtime.http.api.utils.UriCache;

public abstract class GrizzlyHttpMessage
extends BaseHttpMessage
implements HttpRequest {
    protected final InetSocketAddress localAddress;
    protected final boolean isTransferEncodingChunked;
    protected final long contentLength;
    protected final HttpRequestPacket requestPacket;
    private final String baseUri;
    protected String method;
    protected MultiMap<String, String> queryParams;
    protected HttpProtocol protocol;
    protected URI uri;
    protected String path;

    public GrizzlyHttpMessage(HttpRequestPacket requestPacket, MultiMap<String, String> headers, InetSocketAddress localAddress) {
        super(headers);
        this.requestPacket = requestPacket;
        this.localAddress = localAddress;
        this.isTransferEncodingChunked = requestPacket.isChunked();
        this.baseUri = this.getBaseProtocol() + "://" + localAddress.getHostString() + ":" + localAddress.getPort();
        long contentLengthAsLong = this.isTransferEncodingChunked ? -1L : 0L;
        String contentLengthAsString = requestPacket.getHeader("Content-Length");
        if (contentLengthAsString != null) {
            contentLengthAsLong = Long.parseLong(contentLengthAsString);
        }
        this.contentLength = contentLengthAsLong;
    }

    public MultiMap<String, String> getQueryParams() {
        if (this.queryParams == null) {
            this.queryParams = HttpEncoderDecoderUtils.decodeQueryString((String)this.requestPacket.getQueryString());
        }
        return this.queryParams;
    }

    public String getPath() {
        if (this.path == null) {
            this.path = this.requestPacket.getRequestURI();
        }
        return this.path;
    }

    public String getMethod() {
        if (this.method == null) {
            this.method = this.requestPacket.getMethod().getMethodString();
        }
        return this.method;
    }

    public HttpProtocol getProtocol() {
        if (this.protocol == null) {
            this.protocol = this.requestPacket.getProtocol() == Protocol.HTTP_1_0 ? HttpProtocol.HTTP_1_0 : HttpProtocol.HTTP_1_1;
        }
        return this.protocol;
    }

    public Collection<String> getHeaderNames() {
        if (this.headers == null) {
            this.initializeHeaders();
        }
        return this.headers.keySet();
    }

    public String getHeaderValue(String headerName) {
        if (this.headers == null) {
            this.initializeHeaders();
        }
        return (String)this.headers.get((Object)headerName);
    }

    public Collection<String> getHeaderValues(String headerName) {
        if (this.headers == null) {
            this.initializeHeaders();
        }
        return this.headers.getAll((Object)headerName);
    }

    public MultiMap<String, String> getHeaders() {
        if (this.headers == null) {
            this.initializeHeaders();
        }
        return this.headers;
    }

    private void initializeHeaders() {
        this.headers = new CaseInsensitiveMultiMap(!HttpServerProperties.PRESERVE_HEADER_CASE);
        for (String grizzlyHeaderName : this.requestPacket.getHeaders().names()) {
            Iterable headerValues = this.requestPacket.getHeaders().values(grizzlyHeaderName);
            for (String headerValue : headerValues) {
                this.headers.put((Object)grizzlyHeaderName, (Object)headerValue);
            }
        }
        this.headers = this.headers.toImmutableMultiMap();
    }

    public URI getUri() {
        if (this.uri == null) {
            String path = this.requestPacket.getRequestURI() + (StringUtils.isEmpty((String)this.requestPacket.getQueryString()) ? "" : "?" + this.requestPacket.getQueryString());
            try {
                this.uri = UriCache.getUriFromString((String)(this.baseUri + path));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Malformed URI: " + path);
            }
        }
        return this.uri;
    }

    protected abstract String getBaseProtocol();
}

