/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.functional.client;

import io.qameta.allure.Story;
import io.qameta.allure.junit4.DisplayName;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.client.auth.HttpAuthentication;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.InputStreamHttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.service.http.impl.functional.client.HttpClientPostStreamingTestCase;

@Story(value="Streaming")
@DisplayName(value="Validates that the POST body is preserved on NTLM authentication")
public class NtlmHttpClientPostStreamingTestCase
extends HttpClientPostStreamingTestCase {
    public NtlmHttpClientPostStreamingTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    @Override
    public HttpResponse doSetUpHttpResponse(HttpRequest request) {
        HttpResponseBuilder response = HttpResponse.builder();
        String authorization = request.getHeaderValue("authorization");
        if (authorization == null) {
            response.statusCode(Integer.valueOf(HttpConstants.HttpStatus.UNAUTHORIZED.getStatusCode()));
            response.addHeader("WWW-Authenticate", "NTLM");
        } else if (authorization.equals("NTLM TlRMTVNTUAABAAAAAYIIogAAAAAoAAAAAAAAACgAAAAFASgKAAAADw==")) {
            response.statusCode(Integer.valueOf(HttpConstants.HttpStatus.UNAUTHORIZED.getStatusCode()));
            response.addHeader("WWW-Authenticate", "NTLM TlRMTVNTUAACAAAAAAAAACgAAAABggAAU3J2Tm9uY2UAAAAAAAAAAA==");
        } else if (authorization.equals("NTLM TlRMTVNTUAADAAAAGAAYAEgAAAAYABgAYAAAABQAFAB4AAAADAAMAIwAAAAaABoAmAAAAAAAAACyAAAAAYIAAgUBKAoAAAAPrYfKbe/jRoW5xDxHeoxC1gBmfWiS5+iX4OAN4xBKG/IFPwfH3agtPEia6YnhsADTVQBSAFMAQQAtAE0ASQBOAE8AUgBaAGEAcABoAG8AZABCAEEALQBGAEcATwBOAFoAQQAtAE8AUwBYAA==")) {
            this.extractPayload(request);
            response.statusCode(Integer.valueOf(HttpConstants.HttpStatus.OK.getStatusCode()));
        } else {
            this.extractPayload(request);
            response.statusCode(Integer.valueOf(HttpConstants.HttpStatus.UNAUTHORIZED.getStatusCode()));
        }
        return response.build();
    }

    @Override
    public HttpRequestOptions getOptions() {
        HttpAuthentication.HttpNtlmAuthentication authentication = HttpAuthentication.HttpNtlmAuthentication.builder().username("Zaphod").password("Beeblebrox").domain("Ursa-Minor").build();
        return HttpRequestOptions.builder().responseTimeout(3000).authentication((HttpAuthentication)authentication).build();
    }

    @Override
    public HttpRequest getRequest() {
        return ((HttpRequestBuilder)HttpRequest.builder().method(HttpConstants.Method.POST).uri(this.getUri()).entity((HttpEntity)new InputStreamHttpEntity((InputStream)new ByteArrayInputStream("test".getBytes())))).build();
    }
}

