/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.server;

import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsEqual;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.ServerNotFoundException;
import org.mule.service.http.impl.service.server.ContextHttpServerFactory;
import org.mule.service.http.impl.service.server.ContextHttpServerFactoryAdapter;
import org.mule.service.http.impl.service.server.ServerIdentifier;

public class ContextHttpServerFactoryAdapterTestCase {
    private static final String SERVER_CONTEXT = "context";
    private static final String SERVER_PARENT_CONTEXT = "parentContext";
    private static final String SERVER_ID = "serverId";
    private ContextHttpServerFactory delegateFactory;
    private HttpServer mockedServer;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void setUp() {
        this.delegateFactory = (ContextHttpServerFactory)Mockito.mock(ContextHttpServerFactory.class);
        this.mockedServer = (HttpServer)Mockito.mock(HttpServer.class);
    }

    @Test
    public void serverRegisteredWithContext() throws Exception {
        this.mockServerRegisteredWith(SERVER_CONTEXT, SERVER_ID);
        ContextHttpServerFactoryAdapter httpServerFactory = new ContextHttpServerFactoryAdapter(SERVER_CONTEXT, Optional.empty(), this.delegateFactory);
        MatcherAssert.assertThat((Object)httpServerFactory.lookup(SERVER_ID), (Matcher)IsEqual.equalTo((Object)this.mockedServer));
    }

    @Test
    public void serverRegisteredWithParentContext() throws Exception {
        this.mockServerRegisteredWith(SERVER_PARENT_CONTEXT, SERVER_ID);
        ContextHttpServerFactoryAdapter httpServerFactory = new ContextHttpServerFactoryAdapter(SERVER_CONTEXT, Optional.of(SERVER_PARENT_CONTEXT), this.delegateFactory);
        MatcherAssert.assertThat((Object)httpServerFactory.lookup(SERVER_ID), (Matcher)IsEqual.equalTo((Object)this.mockedServer));
    }

    @Test
    public void serverInDifferentParentContextNotFound() throws Exception {
        this.mockServerRegisteredWith("OTHER_PARENT", SERVER_ID);
        ContextHttpServerFactoryAdapter httpServerFactory = new ContextHttpServerFactoryAdapter(SERVER_CONTEXT, Optional.of(SERVER_PARENT_CONTEXT), this.delegateFactory);
        this.expectedException.expect(ServerNotFoundException.class);
        httpServerFactory.lookup(SERVER_ID);
    }

    @Test
    public void serverInDifferentContextNotFound() throws Exception {
        this.mockServerRegisteredWith("OTHER_CONTEXT", SERVER_ID);
        ContextHttpServerFactoryAdapter httpServerFactory = new ContextHttpServerFactoryAdapter(SERVER_CONTEXT, Optional.empty(), this.delegateFactory);
        this.expectedException.expect(ServerNotFoundException.class);
        httpServerFactory.lookup(SERVER_ID);
    }

    private void mockServerRegisteredWith(String context, String serverId) throws Exception {
        Mockito.when((Object)this.delegateFactory.lookup((ServerIdentifier)ArgumentMatchers.any(ServerIdentifier.class))).thenThrow(new Throwable[]{new ServerNotFoundException("")});
        Mockito.when((Object)this.delegateFactory.lookup(this.aServerIdentifierWith(context, serverId))).thenReturn((Object)this.mockedServer);
    }

    private ServerIdentifier aServerIdentifierWith(final String context, final String name) {
        return (ServerIdentifier)ArgumentMatchers.argThat((ArgumentMatcher)new ArgumentMatcher<ServerIdentifier>(){
            private final ServerIdentifier expectedId;
            {
                this.expectedId = new ServerIdentifier(context, name);
            }

            public boolean matches(ServerIdentifier argument) {
                return this.expectedId.equals((Object)argument);
            }
        });
    }
}

