/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.functional.server;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Socket;
import org.apache.http.HttpVersion;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.service.http.impl.functional.server.AbstractHttpServerTestCase;

public class HttpServerCloseTestCase
extends AbstractHttpServerTestCase {
    public HttpServerCloseTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    @Override
    protected String getServerName() {
        return "close-test";
    }

    @Before
    public void setUp() throws Exception {
        this.setUpServer();
        ResponseStatusCallback responseStatusCallback = (ResponseStatusCallback)Mockito.mock(ResponseStatusCallback.class);
        this.server.addRequestHandler("/path", (requestContext, responseCallback) -> responseCallback.responseReady(HttpResponse.builder().statusCode(Integer.valueOf(HttpConstants.HttpStatus.OK.getStatusCode())).build(), responseStatusCallback));
    }

    @Test
    public void closeClientConnectionsWhenServerIsStopped() throws IOException {
        try (Socket clientSocket = new Socket("localhost", this.port.getNumber());){
            MatcherAssert.assertThat((Object)clientSocket.isConnected(), (Matcher)Matchers.is((Object)true));
            this.sendRequest(clientSocket);
            this.assertResponse(this.getResponse(clientSocket), true);
            this.sendRequest(clientSocket);
            this.assertResponse(this.getResponse(clientSocket), true);
            this.server.stop();
            this.sendRequest(clientSocket);
            this.assertResponse(this.getResponse(clientSocket), false);
        }
    }

    private void sendRequest(Socket socket) throws IOException {
        PrintWriter writer = new PrintWriter(socket.getOutputStream());
        writer.println("GET /path " + HttpVersion.HTTP_1_1);
        writer.println("Host: www.example.com");
        writer.println("");
        writer.flush();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getResponse(Socket socket) {
        try (StringWriter writer = new StringWriter();){
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            while (!StringUtils.isEmpty((String)(line = reader.readLine()))) {
                writer.append(line).append("\r\n");
            }
            String string = writer.toString();
            return string;
        }
        catch (IOException e) {
            return null;
        }
    }

    private void assertResponse(String response, boolean shouldBeValid) {
        MatcherAssert.assertThat((Object)StringUtils.isEmpty((String)response), (Matcher)Matchers.is((Object)(!shouldBeValid ? 1 : 0)));
    }
}

