/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.server.grizzly;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.glassfish.grizzly.IOStrategy;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.http.HttpProbe;
import org.glassfish.grizzly.http.HttpServerFilter;
import org.glassfish.grizzly.http.KeepAlive;
import org.glassfish.grizzly.nio.NIOChannelDistributor;
import org.glassfish.grizzly.nio.NIOTransport;
import org.glassfish.grizzly.nio.RoundRobinConnectionDistributor;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.glassfish.grizzly.ssl.SSLFilter;
import org.glassfish.grizzly.utils.DelayedExecutor;
import org.glassfish.grizzly.utils.IdleTimeoutFilter;
import org.glassfish.grizzly.websockets.WebSocketFilter;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.ServerAddress;
import org.mule.runtime.http.api.server.ServerAlreadyExistsException;
import org.mule.runtime.http.api.server.ServerCreationException;
import org.mule.runtime.http.api.server.ServerNotFoundException;
import org.mule.runtime.http.api.tcp.TcpServerSocketProperties;
import org.mule.service.http.impl.service.HttpMessageLogger;
import org.mule.service.http.impl.service.server.HttpListenerRegistry;
import org.mule.service.http.impl.service.server.HttpServerDelegate;
import org.mule.service.http.impl.service.server.HttpServerManager;
import org.mule.service.http.impl.service.server.ServerIdentifier;
import org.mule.service.http.impl.service.server.grizzly.ExecutorPerServerAddressIOStrategy;
import org.mule.service.http.impl.service.server.grizzly.GrizzlyAddressDelegateFilter;
import org.mule.service.http.impl.service.server.grizzly.GrizzlyHttpServer;
import org.mule.service.http.impl.service.server.grizzly.GrizzlyRequestDispatcherFilter;
import org.mule.service.http.impl.service.server.grizzly.IdleExecutor;
import org.mule.service.http.impl.service.server.grizzly.MuleSslFilter;
import org.mule.service.http.impl.service.server.grizzly.WorkManagerSourceExecutorProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrizzlyServerManager
implements HttpServerManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(GrizzlyServerManager.class);
    public static final String MAXIMUM_HEADER_SECTION_SIZE_PROPERTY_KEY = "mule.http.headerSectionSize";
    private static final int MAX_KEEP_ALIVE_REQUESTS = -1;
    private static final int DEFAULT_SERVER_TIMEOUT_MILLIS = 60000;
    private static final int SERVER_TIMEOUT_DELAY_MILLIS = 500;
    private static final int MIN_SELECTORS_FOR_DEDICATED_ACCEPTOR = Integer.getInteger(GrizzlyServerManager.class.getName() + ".MIN_SELECTORS_FOR_DEDICATED_ACCEPTOR", 4);
    private static final long DISPOSE_TIMEOUT_MILLIS = 30000L;
    private final GrizzlyAddressDelegateFilter<IdleTimeoutFilter> timeoutFilterDelegate;
    protected final GrizzlyAddressDelegateFilter<SSLFilter> sslFilterDelegate;
    protected final GrizzlyAddressDelegateFilter<WebSocketFilter> webSocketFilter;
    private final GrizzlyAddressDelegateFilter<HttpServerFilter> httpServerFilterDelegate;
    protected final TCPNIOTransport transport;
    private final GrizzlyRequestDispatcherFilter requestHandlerFilter;
    protected final HttpListenerRegistry httpListenerRegistry;
    protected final WorkManagerSourceExecutorProvider executorProvider;
    private final ExecutorService idleTimeoutExecutorService;
    private final Map<ServerAddress, HttpServer> servers = new ConcurrentHashMap<ServerAddress, HttpServer>();
    private final Map<ServerIdentifier, HttpServer> serversByIdentifier = new ConcurrentHashMap<ServerIdentifier, HttpServer>();
    private final Map<ServerAddress, IdleExecutor> idleExecutorPerServerAddressMap = new ConcurrentHashMap<ServerAddress, IdleExecutor>();
    private boolean transportStarted;
    private int serverTimeout;

    public GrizzlyServerManager(ExecutorService selectorPool, ExecutorService workerPool, ExecutorService idleTimeoutExecutorService, HttpListenerRegistry httpListenerRegistry, TcpServerSocketProperties serverSocketProperties, int selectorCount) {
        this.httpListenerRegistry = httpListenerRegistry;
        this.serverTimeout = Integer.getInteger("mule.http.server.timeout", 60000);
        this.requestHandlerFilter = new GrizzlyRequestDispatcherFilter(httpListenerRegistry);
        this.timeoutFilterDelegate = new GrizzlyAddressDelegateFilter();
        this.sslFilterDelegate = new GrizzlyAddressDelegateFilter();
        this.webSocketFilter = new GrizzlyAddressDelegateFilter();
        this.httpServerFilterDelegate = new GrizzlyAddressDelegateFilter();
        FilterChainBuilder serverFilterChainBuilder = FilterChainBuilder.stateless();
        serverFilterChainBuilder.add((Filter)new TransportFilter());
        serverFilterChainBuilder.add(this.timeoutFilterDelegate);
        serverFilterChainBuilder.add(this.sslFilterDelegate);
        serverFilterChainBuilder.add(this.httpServerFilterDelegate);
        serverFilterChainBuilder.add(this.webSocketFilter);
        serverFilterChainBuilder.add((Filter)this.requestHandlerFilter);
        this.executorProvider = this.createExecutorProvider();
        TCPNIOTransportBuilder transportBuilder = (TCPNIOTransportBuilder)((TCPNIOTransportBuilder)TCPNIOTransportBuilder.newInstance().setOptimizedForMultiplexing(true)).setIOStrategy((IOStrategy)new ExecutorPerServerAddressIOStrategy(this.executorProvider));
        this.configureServerSocketProperties(transportBuilder, serverSocketProperties);
        this.transport = transportBuilder.build();
        this.transport.setNIOChannelDistributor((NIOChannelDistributor)new RoundRobinConnectionDistributor((NIOTransport)this.transport, selectorCount >= MIN_SELECTORS_FOR_DEDICATED_ACCEPTOR, true));
        this.transport.setSelectorRunnersCount(selectorCount);
        this.transport.setWorkerThreadPool(workerPool);
        this.transport.setKernelThreadPool(selectorPool);
        this.transport.setProcessor((Processor)serverFilterChainBuilder.build());
        this.idleTimeoutExecutorService = idleTimeoutExecutorService;
    }

    protected WorkManagerSourceExecutorProvider createExecutorProvider() {
        return new WorkManagerSourceExecutorProvider();
    }

    private void configureServerSocketProperties(TCPNIOTransportBuilder transportBuilder, TcpServerSocketProperties serverSocketProperties) {
        Integer serverTimeout;
        if (serverSocketProperties.getKeepAlive() != null) {
            transportBuilder.setKeepAlive(serverSocketProperties.getKeepAlive().booleanValue());
        }
        if (serverSocketProperties.getLinger() != null) {
            transportBuilder.setLinger(serverSocketProperties.getLinger().intValue());
        }
        if (serverSocketProperties.getReceiveBufferSize() != null) {
            transportBuilder.setReadBufferSize(serverSocketProperties.getReceiveBufferSize().intValue());
        }
        if (serverSocketProperties.getSendBufferSize() != null) {
            transportBuilder.setWriteBufferSize(serverSocketProperties.getSendBufferSize().intValue());
        }
        if (serverSocketProperties.getClientTimeout() != null) {
            transportBuilder.setClientSocketSoTimeout(serverSocketProperties.getClientTimeout().intValue());
        }
        if ((serverTimeout = serverSocketProperties.getServerTimeout()) != null) {
            transportBuilder.setServerSocketSoTimeout(serverTimeout.intValue());
            this.serverTimeout = serverTimeout;
        }
        transportBuilder.setReuseAddress(serverSocketProperties.getReuseAddress().booleanValue());
        transportBuilder.setTcpNoDelay(serverSocketProperties.getSendTcpNoDelay().booleanValue());
        transportBuilder.setServerConnectionBackLog(serverSocketProperties.getReceiveBacklog().intValue());
    }

    private void startTransportIfNotStarted() throws ServerCreationException {
        Thread thread = Thread.currentThread();
        ClassLoader currentClassLoader = thread.getContextClassLoader();
        ClassLoader contextClassLoader = this.getClass().getClassLoader();
        ClassUtils.setContextClassLoader((Thread)thread, (ClassLoader)currentClassLoader, (ClassLoader)contextClassLoader);
        try {
            if (!this.transportStarted) {
                this.transportStarted = true;
                this.transport.start();
            }
        }
        catch (Exception e) {
            throw new ServerCreationException("Transport failed at startup.", (Throwable)e);
        }
        finally {
            ClassUtils.setContextClassLoader((Thread)thread, (ClassLoader)contextClassLoader, (ClassLoader)currentClassLoader);
        }
    }

    @Override
    public boolean containsServerFor(ServerAddress serverAddress, ServerIdentifier identifier) {
        return this.servers.containsKey(serverAddress) || this.containsOverlappingServerFor(serverAddress) || this.serversByIdentifier.containsKey(identifier);
    }

    private boolean containsOverlappingServerFor(ServerAddress newServerAddress) {
        for (ServerAddress serverAddress : this.servers.keySet()) {
            if (!serverAddress.overlaps(newServerAddress)) continue;
            return true;
        }
        return false;
    }

    @Override
    public HttpServer createSslServerFor(TlsContextFactory tlsContextFactory, Supplier<Scheduler> schedulerSupplier, ServerAddress serverAddress, boolean usePersistentConnections, int connectionIdleTimeout, ServerIdentifier identifier) throws ServerCreationException {
        LOGGER.debug("Creating https server socket for ip {} and port {}", (Object)serverAddress.getIp(), (Object)serverAddress.getPort());
        if (this.servers.containsKey(serverAddress)) {
            throw new ServerAlreadyExistsException(serverAddress);
        }
        this.startTransportIfNotStarted();
        DelayedExecutor delayedExecutor = this.createAndGetDelayedExecutor(serverAddress);
        this.addTimeoutFilter(serverAddress, usePersistentConnections, connectionIdleTimeout, delayedExecutor);
        this.sslFilterDelegate.addFilterForAddress(serverAddress, MuleSslFilter.createSslFilter(tlsContextFactory));
        this.httpServerFilterDelegate.addFilterForAddress(serverAddress, this.createHttpServerFilter(connectionIdleTimeout, usePersistentConnections, delayedExecutor, identifier));
        ManagedGrizzlyHttpServer grizzlyServer = this.getManagedServerAndWrapSupplier(serverAddress, schedulerSupplier, identifier);
        this.servers.put(serverAddress, grizzlyServer);
        this.serversByIdentifier.put(identifier, grizzlyServer);
        return grizzlyServer;
    }

    protected ManagedGrizzlyHttpServer createManagedServer(Supplier<Scheduler> schedulerSupplier, ServerAddress serverAddress, ServerIdentifier identifier) {
        return new ManagedGrizzlyHttpServer(new GrizzlyHttpServer(serverAddress, this.transport, this.httpListenerRegistry, schedulerSupplier, () -> this.executorProvider.removeExecutor(serverAddress), this.sslFilterDelegate), identifier);
    }

    @Override
    public HttpServer createServerFor(ServerAddress serverAddress, Supplier<Scheduler> schedulerSupplier, boolean usePersistentConnections, int connectionIdleTimeout, ServerIdentifier identifier) throws ServerCreationException {
        LOGGER.debug("Creating http server socket for ip {} and port {}", (Object)serverAddress.getIp(), (Object)serverAddress.getPort());
        if (this.servers.containsKey(serverAddress)) {
            throw new ServerAlreadyExistsException(serverAddress);
        }
        this.startTransportIfNotStarted();
        DelayedExecutor delayedExecutor = this.createAndGetDelayedExecutor(serverAddress);
        this.addTimeoutFilter(serverAddress, usePersistentConnections, connectionIdleTimeout, delayedExecutor);
        this.httpServerFilterDelegate.addFilterForAddress(serverAddress, this.createHttpServerFilter(connectionIdleTimeout, usePersistentConnections, delayedExecutor, identifier));
        ManagedGrizzlyHttpServer grizzlyServer = this.getManagedServerAndWrapSupplier(serverAddress, schedulerSupplier, identifier);
        this.servers.put(serverAddress, grizzlyServer);
        this.serversByIdentifier.put(identifier, grizzlyServer);
        return grizzlyServer;
    }

    private ManagedGrizzlyHttpServer getManagedServerAndWrapSupplier(ServerAddress serverAddress, Supplier<Scheduler> schedulerSupplier, ServerIdentifier identifier) {
        SchedulerSupplier wrappedSupplier = new SchedulerSupplier(schedulerSupplier, serverAddress, this.executorProvider);
        ManagedGrizzlyHttpServer grizzlyServer = this.createManagedServer(wrappedSupplier, serverAddress, identifier);
        wrappedSupplier.setServer(grizzlyServer);
        return grizzlyServer;
    }

    @Override
    public HttpServer lookupServer(ServerIdentifier identifier) throws ServerNotFoundException {
        HttpServer httpServer = this.serversByIdentifier.get(identifier);
        if (httpServer != null) {
            return new NoLifecycleHttpServer(httpServer);
        }
        throw new ServerNotFoundException(identifier.getName());
    }

    @Override
    public void dispose() {
        if (this.transportStarted) {
            this.transport.shutdown();
            this.servers.clear();
            this.serversByIdentifier.clear();
        }
    }

    private void addTimeoutFilter(ServerAddress serverAddress, boolean usePersistentConnections, int connectionIdleTimeout, DelayedExecutor delayedExecutor) {
        if (!(this.serverTimeout < 0 || usePersistentConnections && connectionIdleTimeout < 0)) {
            int timeout = this.serverTimeout;
            if (usePersistentConnections && this.serverTimeout < connectionIdleTimeout) {
                timeout = connectionIdleTimeout + 500;
            }
            this.timeoutFilterDelegate.addFilterForAddress(serverAddress, new IdleTimeoutFilter(delayedExecutor, (long)timeout, TimeUnit.MILLISECONDS));
        }
    }

    private HttpServerFilter createHttpServerFilter(int connectionIdleTimeout, boolean usePersistentConnections, DelayedExecutor delayedExecutor, ServerIdentifier identifier) {
        KeepAlive ka = null;
        if (usePersistentConnections) {
            ka = new KeepAlive();
            ka.setMaxRequestsCount(-1);
            ka.setIdleTimeoutInSeconds(this.convertToSeconds(connectionIdleTimeout));
        }
        HttpServerFilter httpServerFilter = new HttpServerFilter(true, this.retrieveMaximumHeaderSectionSize(), ka, delayedExecutor);
        httpServerFilter.getMonitoringConfig().addProbes((Object[])new HttpProbe[]{new HttpMessageLogger(HttpMessageLogger.LoggerType.LISTENER, identifier.getName(), Thread.currentThread().getContextClassLoader())});
        httpServerFilter.setAllowPayloadForUndefinedHttpMethods(true);
        return httpServerFilter;
    }

    private int convertToSeconds(int connectionIdleTimeout) {
        if (connectionIdleTimeout < 0) {
            return -1;
        }
        return (int)TimeUnit.MILLISECONDS.toSeconds(connectionIdleTimeout);
    }

    private DelayedExecutor createAndGetDelayedExecutor(ServerAddress serverAddress) {
        IdleExecutor idleExecutor = new IdleExecutor(this.idleTimeoutExecutorService);
        this.idleExecutorPerServerAddressMap.put(serverAddress, idleExecutor);
        return idleExecutor.getIdleTimeoutDelayedExecutor();
    }

    private int retrieveMaximumHeaderSectionSize() {
        try {
            return Integer.valueOf(System.getProperty(MAXIMUM_HEADER_SECTION_SIZE_PROPERTY_KEY, String.valueOf(8192)));
        }
        catch (NumberFormatException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Invalid value %s for %s configuration", System.getProperty(MAXIMUM_HEADER_SECTION_SIZE_PROPERTY_KEY), MAXIMUM_HEADER_SECTION_SIZE_PROPERTY_KEY)), (Throwable)e);
        }
    }

    private class NoLifecycleHttpServer
    extends HttpServerDelegate {
        public NoLifecycleHttpServer(HttpServer delegate) {
            super(delegate);
        }

        @Override
        public HttpServer start() throws IOException {
            return this;
        }

        @Override
        public HttpServer stop() {
            return this;
        }

        @Override
        public void dispose() {
        }
    }

    private static class SchedulerSupplier
    implements Supplier<Scheduler> {
        private final Supplier<Scheduler> original;
        private final ServerAddress serverAddress;
        private final WorkManagerSourceExecutorProvider executorProvider;
        private ManagedGrizzlyHttpServer grizzlyServer;

        SchedulerSupplier(Supplier<Scheduler> original, ServerAddress serverAddress, WorkManagerSourceExecutorProvider executorProvider) {
            this.original = original;
            this.serverAddress = serverAddress;
            this.executorProvider = executorProvider;
        }

        public void setServer(ManagedGrizzlyHttpServer grizzlyServer) {
            this.grizzlyServer = grizzlyServer;
        }

        @Override
        public Scheduler get() {
            this.executorProvider.addExecutor(this.serverAddress, (Supplier)this.grizzlyServer.getDelegate());
            if (this.original == null) {
                return null;
            }
            return this.original.get();
        }
    }

    protected class ManagedGrizzlyHttpServer
    extends HttpServerDelegate {
        private final ServerIdentifier identifier;

        public ManagedGrizzlyHttpServer(HttpServer delegate, ServerIdentifier identifier) {
            super(delegate);
            this.identifier = identifier;
        }

        @Override
        public synchronized HttpServer start() throws IOException {
            ((IdleExecutor)GrizzlyServerManager.this.idleExecutorPerServerAddressMap.get(this.getServerAddress())).start();
            return super.start();
        }

        @Override
        public synchronized void dispose() {
            super.dispose();
            ServerAddress serverAddress = this.getServerAddress();
            GrizzlyServerManager.this.servers.remove(serverAddress);
            GrizzlyServerManager.this.serversByIdentifier.remove(this.identifier);
            GrizzlyServerManager.this.httpListenerRegistry.removeHandlersFor(this.getDelegate());
            long startTime = System.currentTimeMillis();
            while (GrizzlyServerManager.this.requestHandlerFilter.activeRequestsFor(serverAddress) > 0) {
                if (System.currentTimeMillis() > startTime + 30000L) {
                    LOGGER.warn("Dispose of http server for {} timed out.", (Object)serverAddress);
                    break;
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            GrizzlyServerManager.this.httpServerFilterDelegate.removeFilterForAddress(serverAddress);
            GrizzlyServerManager.this.sslFilterDelegate.removeFilterForAddress(serverAddress);
            GrizzlyServerManager.this.timeoutFilterDelegate.removeFilterForAddress(serverAddress);
            ((IdleExecutor)GrizzlyServerManager.this.idleExecutorPerServerAddressMap.get(serverAddress)).dispose();
            GrizzlyServerManager.this.idleExecutorPerServerAddressMap.remove(serverAddress);
        }
    }
}

