/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.util;

import com.ning.http.client.uri.Uri;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;

public class RedirectUtils {
    public static boolean shouldFollowRedirect(HttpResponse response, HttpRequestOptions options, boolean enableMuleRedirect) {
        return enableMuleRedirect && RedirectUtils.isRedirected(response.getStatusCode()) && response.getHeaders().containsKey((Object)"Location") && options.isFollowsRedirect();
    }

    public static boolean isRedirected(int statusCode) {
        switch (statusCode) {
            case 301: 
            case 302: 
            case 303: 
            case 307: 
            case 308: {
                return true;
            }
        }
        return false;
    }

    public static String getMethodForStatusCode(String requestMethod, int responseStatusCode) {
        switch (responseStatusCode) {
            case 301: 
            case 307: 
            case 308: {
                return requestMethod;
            }
            case 302: 
            case 303: {
                return HttpConstants.Method.GET.name();
            }
        }
        throw new IllegalArgumentException("Invalid status code");
    }

    public static HttpRequest createRedirectRequest(HttpResponse response, HttpRequest request) {
        Uri path = Uri.create((Uri)Uri.create((String)request.getUri().toString()), (String)((String)response.getHeaders().get((Object)"Location")));
        return ((HttpRequestBuilder)((HttpRequestBuilder)HttpRequest.builder().uri(path.toUrl()).method(RedirectUtils.getMethodForStatusCode(request.getMethod(), response.getStatusCode())).protocol(request.getProtocol()).headers(request.getHeaders())).entity(request.getEntity())).build();
    }
}

