/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.functional.server;

import io.qameta.allure.Description;
import io.qameta.allure.Issue;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.http.HttpEntity;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.request.HttpRequestContext;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.service.http.impl.functional.AbstractHttpServiceTestCase;
import org.mule.service.http.impl.functional.server.AbstractHttpServerTestCase;

public class HttpServerAfterCompletionTestCase
extends AbstractHttpServerTestCase {
    private static final String PATH = "/workAfterResponse";
    private AsyncRequestHandler afterResponseRequestHandler;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    public HttpServerAfterCompletionTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    @Before
    public void setUp() throws Exception {
        this.setUpServer();
        this.server.addRequestHandler(PATH, (requestContext, responseCallback) -> {
            responseCallback.responseReady(HttpResponse.builder().build(), (ResponseStatusCallback)new AbstractHttpServiceTestCase.IgnoreResponseStatusCallback());
            this.afterResponseRequestHandler.handleRequest(requestContext);
        });
    }

    @Override
    protected String getServerName() {
        return "after-completion-test";
    }

    @Test
    @Issue(value="MULE-19951")
    @Description(value="When reading the request after sending the response, it fails with a meaningful exception.")
    public void failsGracefullyWhenReadAfterCompletion() throws Exception {
        AlphabetGeneratorInputStream infiniteAlphabet = new AlphabetGeneratorInputStream(0x100000L);
        this.afterResponseRequestHandler = new AsyncRequestHandler(requestContext -> {
            InputStream inputStream = requestContext.getRequest().getEntity().getContent();
            MatcherAssert.assertThat((Object)infiniteAlphabet.equals(inputStream), (Matcher)CoreMatchers.is((Object)true));
        });
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpPut httpPut = new HttpPut(this.getUri());
            httpPut.setProtocolVersion((ProtocolVersion)HttpVersion.HTTP_1_1);
            httpPut.setEntity((HttpEntity)new InputStreamEntity((InputStream)infiniteAlphabet));
            httpClient.execute((HttpUriRequest)httpPut).close();
        }
        this.expectedException.expectCause(CoreMatchers.instanceOf(IllegalStateException.class));
        this.expectedException.expectMessage("Reading from this stream is not allowed. Reason: Response already sent");
        this.afterResponseRequestHandler.test();
    }

    @Test
    @Issue(value="MULE-19951")
    @Description(value="When reading the request after sending the response and the request is available because it fitted in memory buffers, succeeds. This is important for backwards compatibility.")
    public void whenDataBufferedAndReadAfterCompletionSucceeds() throws Exception {
        AlphabetGeneratorInputStream infiniteAlphabet = new AlphabetGeneratorInputStream(2048L);
        this.afterResponseRequestHandler = new AsyncRequestHandler(requestContext -> {
            InputStream inputStream = requestContext.getRequest().getEntity().getContent();
            MatcherAssert.assertThat((Object)infiniteAlphabet.equals(inputStream), (Matcher)CoreMatchers.is((Object)true));
        });
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpPut httpPut = new HttpPut(this.getUri());
            httpPut.setProtocolVersion((ProtocolVersion)HttpVersion.HTTP_1_1);
            httpPut.setEntity((HttpEntity)new InputStreamEntity((InputStream)infiniteAlphabet));
            httpClient.execute((HttpUriRequest)httpPut).close();
        }
        this.afterResponseRequestHandler.test();
    }

    private String getUri() {
        return "http://localhost:" + this.port.getValue() + PATH;
    }

    private static class AsyncRequestHandler {
        private Future<?> future;
        private final ExecutorService es = Executors.newSingleThreadExecutor();
        private final ThrowingConsumer<HttpRequestContext> throwingConsumer;
        private final CountDownLatch handleRequestCalledLatch = new CountDownLatch(1);

        public AsyncRequestHandler(ThrowingConsumer<HttpRequestContext> throwingConsumer) {
            this.throwingConsumer = throwingConsumer;
        }

        public void handleRequest(HttpRequestContext requestContext) {
            this.future = this.es.submit(() -> {
                this.throwingConsumer.accept(requestContext);
                return null;
            });
            this.handleRequestCalledLatch.countDown();
        }

        public void test() throws Exception {
            this.handleRequestCalledLatch.await();
            this.future.get();
        }

        public static interface ThrowingConsumer<T> {
            public void accept(T var1) throws Exception;
        }
    }

    private static class AlphabetGeneratorInputStream
    extends InputStream {
        private static final int ALPHABET_SIZE = 25;
        private long offset = 0L;
        private final long limit;

        public AlphabetGeneratorInputStream(long limit) {
            this.limit = limit;
        }

        @Override
        public int read() throws IOException {
            if (this.offset >= this.limit) {
                return -1;
            }
            return this.charFromOffset(this.offset++);
        }

        public long getLimit() {
            return this.limit;
        }

        public boolean equals(InputStream inputStream) throws IOException {
            int c;
            long offset = 0L;
            while ((c = inputStream.read()) >= 0) {
                if (c == this.charFromOffset(offset++)) continue;
                return false;
            }
            return offset == this.getLimit();
        }

        private int charFromOffset(long offset) {
            return (int)(offset % 25L) + 97;
        }
    }
}

