/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.server;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.http.api.domain.entity.InputStreamHttpEntity;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.request.HttpRequestContext;
import org.mule.runtime.http.api.server.async.HttpResponseReadyCallback;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.service.http.impl.service.server.ErrorRequestHandler;
import org.mule.service.http.impl.service.server.NoListenerRequestHandler;
import org.mule.service.http.impl.service.server.NoMethodRequestHandler;
import org.mule.service.http.impl.service.server.ServiceTemporarilyUnavailableListenerRequestHandler;
import org.mule.tck.junit4.AbstractMuleTestCase;

@RunWith(value=Parameterized.class)
public class ErrorRequestHandlerTestCase
extends AbstractMuleTestCase {
    private static final String SCRIPT = "/<script>alert('hello');</script>";
    private final HttpRequestContext context = (HttpRequestContext)Mockito.mock(HttpRequestContext.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    private final HttpResponseReadyCallback responseReadyCallback = (HttpResponseReadyCallback)Mockito.mock(HttpResponseReadyCallback.class);
    @Parameterized.Parameter
    public ErrorRequestHandler errorRequestHandler;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({NoListenerRequestHandler.getInstance()}, {NoMethodRequestHandler.getInstance()}, {ServiceTemporarilyUnavailableListenerRequestHandler.getInstance()});
    }

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.context.getRequest().getPath()).thenReturn((Object)SCRIPT);
    }

    @Test
    public void testInvalidEndpointWithSpecialCharacters() throws Exception {
        String[] result = new String[1];
        ((HttpResponseReadyCallback)Mockito.doAnswer(invocation -> {
            HttpResponse response = (HttpResponse)invocation.getArguments()[0];
            InputStreamHttpEntity inputStreamHttpEntity = (InputStreamHttpEntity)response.getEntity();
            result[0] = IOUtils.toString((InputStream)inputStreamHttpEntity.getContent());
            inputStreamHttpEntity.getContent().close();
            return null;
        }).when((Object)this.responseReadyCallback)).responseReady((HttpResponse)ArgumentMatchers.any(HttpResponse.class), (ResponseStatusCallback)ArgumentMatchers.any(ResponseStatusCallback.class));
        this.errorRequestHandler.handleRequest(this.context, this.responseReadyCallback);
        Assert.assertThat((Object)result[0], (Matcher)Matchers.not((Matcher)Matchers.containsString((String)SCRIPT)));
    }
}

