/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.functional.client;

import io.qameta.allure.Description;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import io.qameta.allure.junit4.DisplayName;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.util.DataUnit;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.InputStreamHttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.runtime.http.api.domain.request.HttpRequestContext;
import org.mule.runtime.http.api.server.RequestHandler;
import org.mule.runtime.http.api.server.async.HttpResponseReadyCallback;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.service.http.impl.functional.FillAndWaitStream;
import org.mule.service.http.impl.functional.ResponseReceivedProbe;
import org.mule.service.http.impl.functional.client.AbstractHttpClientTestCase;
import org.mule.service.http.impl.service.HttpServiceImplementation;
import org.mule.service.http.impl.service.server.grizzly.ResponseStreamingCompletionHandler;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;

@Story(value="Streaming")
@DisplayName(value="Validates ClassLoader manipulation when using the HTTP client against a streaming server.")
public class HttpClientStreamingClassLoaderTestCase
extends AbstractHttpClientTestCase {
    private static final int RESPONSE_TIMEOUT = 30000;
    private static final int TIMEOUT_MILLIS = 30000;
    private static final int POLL_DELAY_MILLIS = 200;
    private PollingProber pollingProber = new PollingProber(30000L, 200L);
    private ResponseStatusCallback statusCallback = (ResponseStatusCallback)Mockito.spy(ResponseStatusCallback.class);
    private Latch latch = new Latch();
    private ClassLoader classLoader;
    private Set<ClassLoader> classLoadersWhileReading;
    @Parameter
    public final boolean replaceCtxClassLoader;

    @Parameterized.Parameters(name="Service: {0}, replaceCtxClassLoader: {1}")
    public static Object[][] parameters() {
        return new Object[][]{{HttpServiceImplementation.class.getName(), true}, {HttpServiceImplementation.class.getName(), false}};
    }

    public HttpClientStreamingClassLoaderTestCase(String serviceToLoad, boolean replaceCtxClassLoader) {
        super(serviceToLoad);
        this.replaceCtxClassLoader = replaceCtxClassLoader;
    }

    @Before
    public void setupClassloader() {
        this.classLoader = new ClassLoader(){};
        this.classLoadersWhileReading = new HashSet<ClassLoader>();
        ResponseStreamingCompletionHandler.setReplaceCtxClassloader((boolean)this.replaceCtxClassLoader);
    }

    @Override
    protected HttpResponse setUpHttpResponse(HttpRequest request) {
        return ((HttpResponseBuilder)HttpResponse.builder().statusCode(Integer.valueOf(HttpConstants.HttpStatus.OK.getStatusCode())).reasonPhrase(HttpConstants.HttpStatus.OK.getReasonPhrase()).entity((HttpEntity)new InputStreamHttpEntity((InputStream)new FillAndWaitStream(this.latch){

            @Override
            public int read() throws IOException {
                HttpClientStreamingClassLoaderTestCase.this.classLoadersWhileReading.add(Thread.currentThread().getContextClassLoader());
                return super.read();
            }
        }))).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Description(value="ContextClassLoader when reading should be as expected, depending on parametrization")
    @Issue(value="MULE-18185")
    public void properClassloaderWhileReading() {
        HttpClientConfiguration.Builder clientBuilder = new HttpClientConfiguration.Builder().setName("streaming-classloading-test");
        HttpClient client = this.service.getClientFactory().create(clientBuilder.setResponseBufferSize(DataUnit.KB.toBytes(10)).setStreaming(false).build());
        client.start();
        Reference responseReference = new Reference();
        try {
            client.sendAsync(this.getRequest(), this.getDefaultOptions(30000)).whenComplete((response, exception) -> {
                Assert.assertThat((Object)response, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
                Assert.assertThat((Object)exception, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
                responseReference.set(response);
            });
            this.pollingProber.check((Probe)new ResponseReceivedProbe((Reference<HttpResponse>)responseReference));
            long differentClassLoadersCount = this.classLoadersWhileReading.stream().filter(cl -> cl != this.classLoader).count();
            if (this.replaceCtxClassLoader) {
                Assert.assertThat((Object)differentClassLoadersCount, (Matcher)Matchers.is((Object)0L));
            } else {
                Assert.assertThat((Object)differentClassLoadersCount, (Matcher)Matchers.is((Object)1L));
            }
        }
        finally {
            client.stop();
        }
    }

    @Test
    @Description(value="ContextClassLoader when a request fails should be as expected depending on parametrization")
    @Issue(value="MULE-18185")
    public void properClassLoaderWhenFails() throws Exception {
        AtomicBoolean sameClassloader = new AtomicBoolean(false);
        ((ResponseStatusCallback)Mockito.doAnswer(i -> {
            sameClassloader.set(Thread.currentThread().getContextClassLoader() == this.classLoader);
            this.latch.release();
            return null;
        }).when((Object)this.statusCallback)).onErrorSendingResponse((Throwable)ArgumentMatchers.any());
        Socket socket = new Socket("localhost", this.port.getNumber());
        this.sendRequest(socket);
        socket.close();
        this.latch.await(10000L, TimeUnit.MILLISECONDS);
        ((ResponseStatusCallback)Mockito.verify((Object)this.statusCallback, (VerificationMode)Mockito.atLeastOnce())).onErrorSendingResponse((Throwable)ArgumentMatchers.any());
        if (this.replaceCtxClassLoader) {
            Assert.assertThat((Object)sameClassloader.get(), (Matcher)Matchers.is((Object)true));
        } else {
            Assert.assertThat((Object)sameClassloader.get(), (Matcher)Matchers.is((Matcher)Matchers.not((Object)true)));
        }
    }

    private void sendRequest(Socket socket) throws IOException {
        PrintWriter writer = new PrintWriter(socket.getOutputStream());
        writer.println("GET /test HTTP/1.1");
        writer.println("Host: www.example.com");
        writer.println("");
        writer.flush();
    }

    private HttpRequest getRequest(String uri) {
        return HttpRequest.builder().uri(uri).build();
    }

    private HttpRequest getRequest() {
        return this.getRequest(this.getUri());
    }

    @Override
    protected RequestHandler getRequestHandler() {
        return new RequestHandler(){

            public void handleRequest(HttpRequestContext requestContext, HttpResponseReadyCallback responseCallback) {
                responseCallback.responseReady(HttpClientStreamingClassLoaderTestCase.this.setUpHttpResponse(requestContext.getRequest()), HttpClientStreamingClassLoaderTestCase.this.statusCallback);
            }

            public ClassLoader getContextClassLoader() {
                return HttpClientStreamingClassLoaderTestCase.this.classLoader;
            }
        };
    }
}

