/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.domain.entity.multipart;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.multipart.HttpPart;
import org.mule.service.http.impl.service.domain.entity.multipart.StreamedMultipartHttpEntity;
import org.mule.tck.junit4.AbstractMuleTestCase;

@Feature(value="HTTP Service")
@Story(value="Entities")
public class StreamedMultipartHttpEntityTestCase
extends AbstractMuleTestCase {
    private static final String MULTIPART_CONTENT = "--the-boundary\r\nContent-Disposition: form-data; name=\"img\"; filename=\"a.png\"\r\nContent-Type: application/json\r\n\r\n{\r\n\t\"key\" : \"value\"\r\n}\r\n--the-boundary\r\nContent-Disposition: form-data; name=\"foo\"\r\n\r\nbar\r\n--the-boundary\r\n";
    private HttpEntity entity;

    @Before
    public void setUp() throws IOException {
        this.entity = new StreamedMultipartHttpEntity((InputStream)new ByteArrayInputStream(MULTIPART_CONTENT.getBytes()), "multipart/form-data; boundary=the-boundary");
    }

    @Test
    public void composed() {
        Assert.assertThat((Object)this.entity.isComposed(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void streaming() {
        Assert.assertThat((Object)this.entity.isStreaming(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void providesArrayIfUnparsed() throws IOException {
        Assert.assertThat((Object)this.entity.getBytes(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)MULTIPART_CONTENT.getBytes())));
    }

    @Test
    public void failsToProvideArrayIfParsed() throws IOException {
        Assert.assertThat((Object)this.entity.getParts(), (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat((Object)this.entity.getBytes().length, (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void providesStreamIfUnparsed() throws IOException {
        Assert.assertThat((Object)IOUtils.toString((InputStream)this.entity.getContent()), (Matcher)Matchers.is((Object)MULTIPART_CONTENT));
    }

    @Test
    public void failsToProvideStreamIfParsed() throws IOException {
        Assert.assertThat((Object)this.entity.getParts(), (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat((Object)IOUtils.toString((InputStream)this.entity.getContent()), (Matcher)Matchers.is((Object)""));
    }

    @Test
    public void hasParts() throws IOException {
        Object[] parts = this.entity.getParts().toArray();
        Assert.assertThat((Object)parts, (Matcher)Matchers.arrayWithSize((int)2));
        HttpPart part1 = (HttpPart)parts[0];
        Assert.assertThat((Object)part1.getContentType(), (Matcher)Matchers.is((Object)MediaType.APPLICATION_JSON.toRfcString()));
        Assert.assertThat((Object)part1.getName(), (Matcher)Matchers.is((Object)"img"));
        Assert.assertThat((Object)part1.getFileName(), (Matcher)Matchers.is((Object)"a.png"));
        Assert.assertThat((Object)IOUtils.toString((InputStream)part1.getInputStream()), (Matcher)Matchers.is((Object)"{\r\n\t\"key\" : \"value\"\r\n}"));
        HttpPart part2 = (HttpPart)parts[1];
        Assert.assertThat((Object)part2.getContentType(), (Matcher)Matchers.is((Object)MediaType.TEXT.toRfcString()));
        Assert.assertThat((Object)part2.getName(), (Matcher)Matchers.is((Object)"foo"));
        Assert.assertThat((Object)part2.getFileName(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)IOUtils.toString((InputStream)part2.getInputStream()), (Matcher)Matchers.is((Object)"bar"));
    }

    @Test
    public void hasNoSizeUnlessSpecified() {
        Assert.assertThat((Object)this.entity.getBytesLength().isPresent(), (Matcher)Matchers.is((Object)false));
        StreamedMultipartHttpEntity specifiedEntity = new StreamedMultipartHttpEntity((InputStream)new ByteArrayInputStream(MULTIPART_CONTENT.getBytes()), "multipart/form-data; boundary=the-boundary", Long.valueOf(MULTIPART_CONTENT.length()));
        Assert.assertThat((Object)specifiedEntity.getBytesLength().getAsLong(), (Matcher)Matchers.is((Object)MULTIPART_CONTENT.length()));
    }
}

