/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.server.grizzly;

import java.net.InetSocketAddress;
import java.net.URI;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.service.http.impl.service.server.grizzly.GrizzlyHttpRequestAdapter;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class GrizzlyHttpRequestAdapterTestCase
extends AbstractMuleTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private HttpRequest request;
    private HttpRequestPacket requestPacket = (HttpRequestPacket)Mockito.mock(HttpRequestPacket.class);

    @Before
    public void setUp() {
        HttpContent content = (HttpContent)Mockito.mock(HttpContent.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)content.isLast()).thenReturn((Object)true);
        Mockito.when((Object)this.requestPacket.getRequestURI()).thenReturn((Object)"/song");
        this.request = new GrizzlyHttpRequestAdapter((FilterChainContext)Mockito.mock(FilterChainContext.class), content, this.requestPacket, new InetSocketAddress("hidden", 29));
    }

    @Test
    public void hidesHostWhenFailing() {
        Mockito.when((Object)this.requestPacket.getQueryString()).thenReturn((Object)"id=0618%");
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage(Matchers.is((Object)"Malformed URI: /song?id=0618%"));
        this.request.getUri();
    }

    @Test
    public void providesCorrectUri() {
        Mockito.when((Object)this.requestPacket.getQueryString()).thenReturn((Object)"id=0618");
        URI uri = this.request.getUri();
        Assert.assertThat((Object)uri.getHost(), (Matcher)Matchers.is((Object)"hidden"));
        Assert.assertThat((Object)uri.getPort(), (Matcher)Matchers.is((Object)29));
        Assert.assertThat((Object)uri.getPath(), (Matcher)Matchers.is((Object)"/song"));
        Assert.assertThat((Object)uri.getQuery(), (Matcher)Matchers.is((Object)"id=0618"));
    }
}

