/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.functional.client;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.InputStreamHttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.service.http.impl.functional.client.AbstractHttpRedirectClientTestCase;
import org.mule.service.http.impl.service.HttpServiceImplementation;
import org.mule.tck.junit4.rule.SystemProperty;

@Feature(value="HTTP Service")
@Issue(value="MULE-19908")
public class GrizzlyHttpClientRedirectTestCase
extends AbstractHttpRedirectClientTestCase {
    private HttpClient client;
    @Rule
    public MockitoRule mockitorule = MockitoJUnit.rule();
    @Rule
    public SystemProperty enableRedirect = new SystemProperty("mule.http.enableMuleRedirect", "true");
    private final HttpClientConfiguration.Builder clientBuilder = new HttpClientConfiguration.Builder().setName("redirect-test");
    public boolean streamingMode;

    public GrizzlyHttpClientRedirectTestCase(String serviceToLoad, boolean streamingMode) {
        super(serviceToLoad);
        this.streamingMode = streamingMode;
    }

    @Parameterized.Parameters(name="streaming mode: {1}")
    public static Iterable<Object[]> params() {
        return Arrays.asList({HttpServiceImplementation.class.getName(), true}, {HttpServiceImplementation.class.getName(), false});
    }

    @Before
    public void before() {
        this.client = this.service.getClientFactory().create(this.clientBuilder.setStreaming(this.streamingMode).build());
        this.client.start();
    }

    @After
    public void stopClient() {
        if (this.client != null) {
            this.client.stop();
        }
    }

    @Test
    public void sendRequestWithSetCookieHeader() throws IOException, TimeoutException {
        HttpResponse response = this.client.send(this.getRequest());
        this.testRedirectResponse(response);
    }

    @Test
    public void sendAsyncRequestWithSetCookieHeader() throws TimeoutException, ExecutionException, InterruptedException {
        CompletableFuture response = this.client.sendAsync(this.getRequest());
        this.testRedirectResponse((HttpResponse)response.get(10000L, TimeUnit.MILLISECONDS));
    }

    private void testRedirectResponse(HttpResponse response) {
        Assert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
        String payload = IOUtils.toString((InputStream)response.getEntity().getContent());
        Assert.assertThat((Object)payload, (Matcher)Matchers.is((Object)"test"));
    }

    private HttpRequest getRequest() {
        return this.getRequest(this.getRedirectUri());
    }

    private HttpRequest getRequest(String uri) {
        return HttpRequest.builder().uri(uri).build();
    }

    @Override
    protected HttpResponse setUpHttpResponse(HttpRequest request) {
        Assert.assertThat((Object)request.getHeaders().get((Object)"Cookie"), (Matcher)Matchers.is((Object)"test1=test1; test2=test2"));
        return ((HttpResponseBuilder)HttpResponse.builder().statusCode(Integer.valueOf(HttpConstants.HttpStatus.OK.getStatusCode())).reasonPhrase(HttpConstants.HttpStatus.OK.getReasonPhrase()).entity((HttpEntity)new InputStreamHttpEntity((InputStream)new ByteArrayInputStream("test".getBytes())))).build();
    }

    @Override
    protected HttpResponse setUpHttpRedirectResponse(HttpRequest request) {
        return ((HttpResponseBuilder)((HttpResponseBuilder)((HttpResponseBuilder)((HttpResponseBuilder)((HttpResponseBuilder)((HttpResponseBuilder)HttpResponse.builder().statusCode(Integer.valueOf(HttpConstants.HttpStatus.MOVED_PERMANENTLY.getStatusCode())).reasonPhrase(HttpConstants.HttpStatus.MOVED_PERMANENTLY.getReasonPhrase()).addHeader("Location", this.getUri())).addHeader("Set-Cookie", "test1=test1")).addHeader("Set-Cookie", "test2=test2thisShouldBeReplaced")).addHeader("Set-Cookie", "test2=test2")).addHeader("Set-Cookie", "test3=test3thisShouldBeRemoved")).addHeader("Set-Cookie", "test3=test3; Expires=Sat, 02 Oct 1993 14:20:00 GMT")).build();
    }
}

