/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.functional.server;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Socket;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.InputStreamHttpEntity;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.service.http.impl.functional.FillAndWaitStream;
import org.mule.service.http.impl.functional.server.AbstractHttpServerTestCase;
import org.mule.tck.probe.JUnitProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;

public class HttpServerStatusCallbackTestCase
extends AbstractHttpServerTestCase {
    private Latch latch = new Latch();
    private ResponseStatusCallback statusCallback = (ResponseStatusCallback)Mockito.spy(ResponseStatusCallback.class);

    public HttpServerStatusCallbackTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    @Before
    public void setUp() throws Exception {
        this.setUpServer();
        this.server.addRequestHandler("/test", (requestContext, responseCallback) -> responseCallback.responseReady(((HttpResponseBuilder)HttpResponse.builder().entity((HttpEntity)new InputStreamHttpEntity((InputStream)new FillAndWaitStream(this.latch)))).build(), this.statusCallback));
    }

    @Override
    protected String getServerName() {
        return "status-callback";
    }

    @Test
    public void failedResponseTriggersError() throws Exception {
        Socket socket = new Socket("localhost", this.port.getNumber());
        this.sendRequest(socket);
        this.getResponseStatus(socket);
        socket.close();
        this.latch.release();
        new PollingProber(2000L, 200L).check((Probe)new JUnitProbe(){

            protected boolean test() throws Exception {
                ((ResponseStatusCallback)Mockito.verify((Object)HttpServerStatusCallbackTestCase.this.statusCallback, (VerificationMode)Mockito.atLeastOnce())).onErrorSendingResponse((Throwable)ArgumentMatchers.any());
                return true;
            }
        });
    }

    private void sendRequest(Socket socket) throws IOException {
        PrintWriter writer = new PrintWriter(socket.getOutputStream());
        writer.println("GET /test HTTP/1.1");
        writer.println("Host: www.example.com");
        writer.println("");
        writer.flush();
    }

    private String getResponseStatus(Socket socket) {
        try {
            String response;
            StringWriter writer = new StringWriter();
            BufferedReader reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            if (reader != null) {
                String line;
                while (!StringUtils.isBlank((String)(line = reader.readLine()))) {
                    writer.append(line).append("\r\n");
                }
            }
            return (response = writer.toString()).length() == 0 ? null : response;
        }
        catch (IOException e) {
            return null;
        }
    }
}

